/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.config;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.construct.Flow;
import org.mule.module.xml.filters.IsXmlFilter;
import org.mule.module.xml.filters.JXPathFilter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class XmlFilterNamespaceHandlerFlowTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/module/xml/xml-filter-functional-test-flow.xml";
    }

    @Test
    public void testIsXmlFilter() throws Exception {
        Object flow = muleContext.getRegistry().lookupObject("test for xml");
        ArrayList outEndpoints = new ArrayList(2);
        outEndpoints.add(((Flow)flow).getMessageProcessors().get(0));
        MessageProcessorChain notXmlSubFlow = (MessageProcessorChain)muleContext.getRegistry().lookupObject("notXml");
        outEndpoints.add(notXmlSubFlow.getMessageProcessors().get(0));
        Assert.assertEquals((long)2L, (long)outEndpoints.size());
        Assert.assertTrue((String)((MessageProcessor)outEndpoints.get(0)).getClass().getName(), (boolean)(outEndpoints.get(0) instanceof MessageFilter));
        Assert.assertTrue((boolean)(((MessageFilter)outEndpoints.get(0)).getFilter() instanceof IsXmlFilter));
        Assert.assertTrue((String)((MessageProcessor)outEndpoints.get(1)).getClass().getName(), (boolean)(outEndpoints.get(1) instanceof MessageFilter));
        Assert.assertTrue((boolean)(((MessageFilter)outEndpoints.get(1)).getFilter() instanceof NotFilter));
        Assert.assertTrue((boolean)(((NotFilter)((MessageFilter)outEndpoints.get(1)).getFilter()).getFilter() instanceof IsXmlFilter));
    }

    @Test
    public void testJXPathFilter() {
        Object flow = muleContext.getRegistry().lookupObject("filter xml for content");
        ArrayList outEndpoints = new ArrayList(1);
        outEndpoints.add(((Flow)flow).getMessageProcessors().get(0));
        Assert.assertEquals((long)1L, (long)outEndpoints.size());
        Assert.assertTrue((String)((MessageProcessor)outEndpoints.get(0)).getClass().getName(), (boolean)(outEndpoints.get(0) instanceof MessageFilter));
        Assert.assertTrue((boolean)(((MessageFilter)outEndpoints.get(0)).getFilter() instanceof JXPathFilter));
        JXPathFilter filter = (JXPathFilter)((MessageFilter)outEndpoints.get(0)).getFilter();
        Assert.assertEquals((Object)"filter xml for content", (Object)filter.getExpectedValue());
        Assert.assertEquals((Object)"/mule:mule/mule:flow[2]/@name", (Object)filter.getPattern());
        Assert.assertNotNull((Object)filter.getNamespaces());
        Map namespaces = filter.getNamespaces();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertEquals((Object)"http://www.springframework.org/schema/beans", namespaces.get("spring"));
        Assert.assertTrue((boolean)namespaces.get("mule").toString().startsWith("http://www.mulesoft.org/schema/mule/core"));
    }
}

