/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.context.notification.ProcessorsTrace;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ProcessorsTraceTestCase
extends FunctionalTestCase {
    @Rule
    public SystemProperty flowTraceEnabled = new SystemProperty("mule.flowTrace", "true");

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/processors-trace-config.xml";
    }

    @Before
    public void before() {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        ProcessorsTraceAsserter.processorsTraceToAssert = null;
        ProcessorsTraceAsyncAsserter.latch = new CountDownLatch(1);
    }

    @Test
    public void flowStatic() throws Exception {
        muleContext.getClient().send("vm://in-flowStatic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowStatic/processors/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowStatic() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStatic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowStatic/processors/0", "/subFlowStatic/processors/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowDynamic/processors/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowDynamic/processors/0", "/subFlowDynamic/processors/0/subFlow/subprocessors/0"));
    }

    @Test
    public void secondFlowStatic() throws Exception {
        muleContext.getClient().send("vm://in-secondFlowStatic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/secondFlowStatic/processors/0", "/flow/processors/0", "/secondFlowStatic/processors/1"));
    }

    @Test
    public void secondSubFlowStatic() throws Exception {
        muleContext.getClient().send("vm://in-secondSubFlowStatic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/secondSubFlowStatic/processors/0", "/secondSubFlowStatic/processors/0/subFlow/subprocessors/0", "/secondSubFlowStatic/processors/1", "/secondSubFlowStatic/processors/1/subFlow/subprocessors/0"));
    }

    @Test
    public void secondFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-secondFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/secondFlowDynamic/processors/0", "/flow/processors/0", "/secondFlowDynamic/processors/1"));
    }

    @Test
    public void secondSubFlowDynamic() throws Exception {
        muleContext.getClient().send("vm://in-secondSubFlowDynamic", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/secondSubFlowDynamic/processors/0", "/secondSubFlowDynamic/processors/0/subFlow/subprocessors/0", "/secondSubFlowDynamic/processors/1", "/secondSubFlowDynamic/processors/1/subFlow/subprocessors/0"));
    }

    @Test
    public void flowStaticWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowStaticWithAsync/processors/0", "/flowStaticWithAsync/processors/0/0", "/flowInAsync/processors/0"));
    }

    @Test
    public void subFlowStaticWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowStaticWithAsync/processors/0", "/subFlowStaticWithAsync/processors/0/0", "/subFlowStaticWithAsync/processors/0/0/subFlowInAsync/subprocessors/0"));
    }

    @Test
    public void flowDynamicWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowDynamicWithAsync/processors/0", "/flowDynamicWithAsync/processors/0/0", "/flowInAsync/processors/0"));
    }

    @Test
    public void subFlowDynamicWithAsync() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithAsync", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowDynamicWithAsync/processors/0", "/subFlowDynamicWithAsync/processors/0/0", "/subFlowDynamicWithAsync/processors/0/0/subFlowInAsync/subprocessors/0"));
    }

    @Test
    public void flowStaticWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowStaticWithEnricher/processors/0", "/flowStaticWithEnricher/processors/0/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowStaticWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowStaticWithEnricher/processors/0", "/subFlowStaticWithEnricher/processors/0/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowDynamicWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowDynamicWithEnricher/processors/0", "/flowDynamicWithEnricher/processors/0/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithEnricher() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithEnricher", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowDynamicWithEnricher/processors/0", "/subFlowDynamicWithEnricher/processors/0/0", "/subFlowDynamicWithEnricher/processors/0/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowStaticWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowStaticWithChoice/processors/0", "/flowStaticWithChoice/processors/0/0/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowStaticWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowStaticWithChoice/processors/0", "/subFlowStaticWithChoice/processors/0/0/0", "/subFlowStaticWithChoice/processors/0/0/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowDynamicWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/flowDynamicWithChoice/processors/0", "/flowDynamicWithChoice/processors/0/0/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithChoice() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithChoice", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("/subFlowDynamicWithChoice/processors/0", "/subFlowDynamicWithChoice/processors/0/0/0", "/subFlowDynamicWithChoice/processors/0/0/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowStaticWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/flowStaticWithScatterGather/processors/0", "/flowStaticWithScatterGather/processors/0/0/0", "/flowStaticWithScatterGather/processors/0/1/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowStaticWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/subFlowStaticWithScatterGather/processors/0", "/subFlowStaticWithScatterGather/processors/0/0/0", "/subFlowStaticWithScatterGather/processors/0/1", "/subFlowStaticWithScatterGather/processors/0/1/subFlow/subprocessors/0"));
    }

    @Ignore(value="MULE-6926: flaky test")
    @Test
    public void flowDynamicWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/flowDynamicWithScatterGather/processors/0", "/flowDynamicWithScatterGather/processors/0/0/0", "/flowDynamicWithScatterGather/processors/0/1/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithScatterGather() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithScatterGather", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/subFlowDynamicWithScatterGather/processors/0", "/subFlowDynamicWithScatterGather/processors/0/0/0", "/subFlowDynamicWithScatterGather/processors/0/1/0", "/subFlowDynamicWithScatterGather/processors/0/1/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowStaticWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-flowStaticWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/flowStaticWithScatterGatherChain/processors/0", "/flowStaticWithScatterGatherChain/processors/0/0/0", "/flowStaticWithScatterGatherChain/processors/0/1", "/flowStaticWithScatterGatherChain/processors/0/1/0", "/flow/processors/0"));
    }

    @Ignore(value="MULE-6926: flaky test")
    @Test
    public void subFlowStaticWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-subFlowStaticWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/subFlowStaticWithScatterGatherChain/processors/0", "/subFlowStaticWithScatterGatherChain/processors/0/0/0", "/subFlowStaticWithScatterGatherChain/processors/0/1", "/subFlowStaticWithScatterGatherChain/processors/0/1/0", "/subFlowStaticWithScatterGatherChain/processors/0/1/0/subFlow/subprocessors/0"));
    }

    @Test
    public void flowDynamicWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-flowDynamicWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/flowDynamicWithScatterGatherChain/processors/0", "/flowDynamicWithScatterGatherChain/processors/0/0/0", "/flowDynamicWithScatterGatherChain/processors/0/1", "/flowDynamicWithScatterGatherChain/processors/0/1/0", "/flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithScatterGatherChain() throws Exception {
        muleContext.getClient().send("vm://in-subFlowDynamicWithScatterGatherChain", (MuleMessage)new DefaultMuleMessage((Object)"payload", muleContext));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("/subFlowDynamicWithScatterGatherChain/processors/0", "/subFlowDynamicWithScatterGatherChain/processors/0/0/0", "/subFlowDynamicWithScatterGatherChain/processors/0/1", "/subFlowDynamicWithScatterGatherChain/processors/0/1/0", "/subFlowDynamicWithScatterGatherChain/processors/0/1/0/subFlow/subprocessors/0"));
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessors(String ... expectedProcessors) {
        return new ProcessorsMatcher(expectedProcessors){

            @Override
            protected void doMatch(ProcessorsTrace processorsTrace, int i, String expectedProcessor) {
                Matcher processorItemMatcher = CoreMatchers.startsWith((String)(expectedProcessor + " @"));
                if (!processorItemMatcher.matches(processorsTrace.getExecutedProcessors().get(i))) {
                    this.failed.add(processorItemMatcher);
                }
            }
        };
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessorsNoOrder(String ... expectedProcessors) {
        return new ProcessorsMatcher(expectedProcessors){

            @Override
            protected void doMatch(ProcessorsTrace processorsTrace, int i, String expectedProcessor) {
                Matcher processorItemMatcher = CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)(expectedProcessor + " @")));
                if (!processorItemMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                    this.failed.add(processorItemMatcher);
                }
            }
        };
    }

    private abstract class ProcessorsMatcher
    extends TypeSafeMatcher<ProcessorsTrace> {
        protected List<Matcher> failed = new ArrayList<Matcher>();
        protected String[] expectedProcessors;

        public ProcessorsMatcher(String[] expectedProcessors) {
            this.expectedProcessors = expectedProcessors;
        }

        protected boolean matchesSafely(ProcessorsTrace processorsTrace) {
            Matcher sizeMatcher = IsCollectionWithSize.hasSize((int)this.expectedProcessors.length);
            if (!sizeMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                this.failed.add(sizeMatcher);
            }
            int i = 0;
            for (String expectedProcessor : this.expectedProcessors) {
                this.doMatch(processorsTrace, i, expectedProcessor);
                ++i;
            }
            return this.failed.isEmpty();
        }

        protected abstract void doMatch(ProcessorsTrace var1, int var2, String var3);

        public void describeTo(Description description) {
            description.appendValue(Arrays.asList(this.expectedProcessors));
        }

        protected void describeMismatchSafely(ProcessorsTrace item, Description description) {
            description.appendText("was ").appendValue((Object)item.getExecutedProcessors());
        }
    }

    public static class ProcessorsTraceAsyncAsserter
    extends ProcessorsTraceAsserter {
        public static CountDownLatch latch;

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            super.process(event);
            latch.countDown();
            return event;
        }
    }

    public static class ProcessorsTraceAsserter
    implements MessageProcessor {
        public static ProcessorsTrace processorsTraceToAssert;

        public MuleEvent process(MuleEvent event) throws MuleException {
            processorsTraceToAssert = event.getProcessorsTrace();
            return event;
        }
    }
}

