/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.component.JavaComponent;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.context.MuleContextFactory;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.component.AbstractJavaComponent;
import org.mule.component.DefaultInterfaceBinding;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.component.simple.PassThroughComponent;
import org.mule.config.PoolingProfile;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.config.spring.parsers.specific.ComponentDelegatingDefinitionParser;
import org.mule.config.spring.parsers.specific.DummyComponentWithBinding;
import org.mule.config.spring.util.SpringBeanLookup;
import org.mule.construct.Flow;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.model.resolvers.ArrayEntryPointResolver;
import org.mule.model.resolvers.CallableEntryPointResolver;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.model.resolvers.ExplicitMethodEntryPointResolver;
import org.mule.model.resolvers.MethodHeaderPropertyEntryPointResolver;
import org.mule.model.resolvers.NoArgumentsEntryPointResolver;
import org.mule.model.resolvers.ReflectionEntryPointResolver;
import org.mule.object.PrototypeObjectFactory;
import org.mule.object.SingletonObjectFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestComponentLifecycleAdapterFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;

public class ComponentDefinitionParserFlowTestCase
extends AbstractMuleTestCase {
    private MuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private MuleContext muleContext;

    @After
    public void after() {
        if (this.muleContext != null) {
            this.muleContext.dispose();
        }
    }

    @Test
    public void testDefaultJavaComponentShortcut() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service1");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(DefaultJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(PrototypeObjectFactory.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)2L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof ArrayEntryPointResolver));
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[1] instanceof CallableEntryPointResolver));
    }

    @Test
    public void testDefaultJavaComponentPrototype() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service2");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(DefaultJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(PrototypeObjectFactory.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)1L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof CallableEntryPointResolver));
    }

    @Test
    public void testDefaultJavaComponentSingleton() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service3");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(DefaultJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(SingletonObjectFactory.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)1L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof ExplicitMethodEntryPointResolver));
    }

    @Test
    public void testDefaultJavaComponentSpringBean() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service4");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(DefaultJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(SpringBeanLookup.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)1L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof NoArgumentsEntryPointResolver));
    }

    private void validatePoolingProfile(Flow service) {
        Assert.assertNotNull((Object)((PooledJavaComponent)service.getMessageProcessors().get(0)).getPoolingProfile());
        Assert.assertNotNull((Object)((PooledJavaComponent)service.getMessageProcessors().get(0)).getPoolingProfile());
        PoolingProfile profile = ((PooledJavaComponent)service.getMessageProcessors().get(0)).getPoolingProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertEquals((String)"exhausted:", (long)0L, (long)profile.getExhaustedAction());
        Assert.assertEquals((String)"initialisation:", (long)2L, (long)profile.getInitialisationPolicy());
        Assert.assertEquals((String)"active:", (long)1L, (long)profile.getMaxActive());
        Assert.assertEquals((String)"idle:", (long)2L, (long)profile.getMaxIdle());
        Assert.assertEquals((String)"wait:", (long)3L, (long)profile.getMaxWait());
    }

    @Test
    public void testPooledJavaComponentShortcut() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service5");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(PooledJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(PrototypeObjectFactory.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        this.validatePoolingProfile(service);
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)1L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof MethodHeaderPropertyEntryPointResolver));
    }

    @Test
    public void testPooledJavaComponentPrototype() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service6");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(PooledJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(PrototypeObjectFactory.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        this.validatePoolingProfile(service);
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)1L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof ReflectionEntryPointResolver));
    }

    @Test
    public void testPooledJavaComponentSingleton() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service7");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(PooledJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(SingletonObjectFactory.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        this.validatePoolingProfile(service);
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
        Assert.assertEquals((long)1L, (long)((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().size());
        Assert.assertTrue((boolean)(((DefaultEntryPointResolverSet)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet()).getEntryPointResolvers().toArray()[0] instanceof ReflectionEntryPointResolver));
    }

    @Test
    public void testPooledJavaComponentSpringBean() throws Exception {
        SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-ok-test-flow.xml");
        this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
        Flow service = (Flow)this.muleContext.getRegistry().lookupObject("service8");
        this.validateCorrectServiceCreation(service);
        Assert.assertEquals(PooledJavaComponent.class, ((MessageProcessor)service.getMessageProcessors().get(0)).getClass());
        Assert.assertEquals(SpringBeanLookup.class, ((AbstractJavaComponent)service.getMessageProcessors().get(0)).getObjectFactory().getClass());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        this.validatePoolingProfile(service);
        Assert.assertNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getEntryPointResolverSet());
    }

    @Test
    public void testClassAttributeAndObjectFactory() throws Exception {
        try {
            SpringXmlConfigurationBuilder configBuilder = new SpringXmlConfigurationBuilder("org/mule/config/spring/parsers/specific/component-bad-test-flow.xml");
            this.muleContextFactory.createMuleContext((ConfigurationBuilder)configBuilder);
            throw new IllegalStateException("Expected config to fail");
        }
        catch (Exception e) {
            Assert.assertEquals(ConfigurationException.class, e.getClass());
            Assert.assertEquals(InitialisationException.class, e.getCause().getClass());
            Assert.assertEquals(BeanDefinitionStoreException.class, e.getCause().getCause().getClass());
            Assert.assertEquals(ComponentDelegatingDefinitionParser.CheckExclusiveClassAttributeObjectFactoryException.class, e.getCause().getCause().getCause().getClass());
            return;
        }
    }

    protected void validateCorrectServiceCreation(Flow service) throws Exception {
        Assert.assertNotNull((Object)service);
        Assert.assertNotNull(service.getMessageProcessors().get(0));
        Assert.assertFalse((boolean)(service.getMessageProcessors().get(0) instanceof PassThroughComponent));
        Assert.assertTrue((boolean)(service.getMessageProcessors().get(0) instanceof JavaComponent));
        Assert.assertEquals(DummyComponentWithBinding.class, (Object)((JavaComponent)service.getMessageProcessors().get(0)).getObjectType());
        Assert.assertNotNull((Object)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings());
        Assert.assertEquals((long)1L, (long)((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().size());
        Assert.assertTrue((boolean)(((JavaComponent)service.getMessageProcessors().get(0)).getInterfaceBindings().get(0) instanceof DefaultInterfaceBinding));
        Assert.assertTrue((boolean)(((JavaComponent)service.getMessageProcessors().get(0)).getLifecycleAdapterFactory() instanceof TestComponentLifecycleAdapterFactory));
    }

    protected MuleContext createMuleContext() throws Exception {
        return null;
    }
}

