/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.endpoint;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.construct.Flow;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class EndpointMessageProcessorsTestCase
extends AbstractServiceAndFlowTestCase {
    public EndpointMessageProcessorsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/config/spring/parsers/endpoint/endpoint-message-processors-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/config/spring/parsers/endpoint/endpoint-message-processors-flow.xml"});
    }

    @Test
    public void testGlobalEndpoint1() throws MuleException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep1");
        List processors = endpoint.getMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)1L, (long)processors.size());
        Assert.assertTrue((boolean)(processors.get(0) instanceof TestMessageProcessor));
        processors = endpoint.getResponseMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)1L, (long)processors.size());
        Assert.assertTrue((boolean)(processors.get(0) instanceof MessageProcessorChain));
    }

    @Test
    public void testGlobalEndpoint2() throws MuleException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep2");
        List processors = endpoint.getMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)2L, (long)processors.size());
        Assert.assertEquals((Object)"1", (Object)((TestMessageProcessor)processors.get(0)).getLabel());
        Assert.assertEquals((Object)"2", (Object)((TestMessageProcessor)processors.get(1)).getLabel());
        processors = endpoint.getResponseMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)1L, (long)processors.size());
        Assert.assertTrue((boolean)(processors.get(0) instanceof MessageProcessorChain));
        MessageProcessorChain chain = (MessageProcessorChain)processors.get(0);
        Assert.assertEquals((Object)"3", (Object)((TestMessageProcessor)chain.getMessageProcessors().get(0)).getLabel());
        Assert.assertEquals((Object)"4", (Object)((TestMessageProcessor)chain.getMessageProcessors().get(1)).getLabel());
    }

    @Test
    public void testLocalEndpoints() throws MuleException {
        InboundEndpoint endpoint;
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            Flow service = (Flow)muleContext.getRegistry().lookupObject("localEndpoints");
            endpoint = (ImmutableEndpoint)service.getMessageSource();
        } else {
            endpoint = ((ServiceCompositeMessageSource)muleContext.getRegistry().lookupService("localEndpoints").getMessageSource()).getEndpoint("ep3");
        }
        List processors = endpoint.getMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)2L, (long)processors.size());
        Assert.assertEquals((Object)"A", (Object)((TestMessageProcessor)processors.get(0)).getLabel());
        Assert.assertEquals((Object)"B", (Object)((TestMessageProcessor)processors.get(1)).getLabel());
        processors = endpoint.getResponseMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)1L, (long)processors.size());
        Assert.assertTrue((boolean)(processors.get(0) instanceof MessageProcessorChain));
        MessageProcessorChain chain = (MessageProcessorChain)processors.get(0);
        Assert.assertEquals((long)2L, (long)chain.getMessageProcessors().size());
        Assert.assertEquals((Object)"C", (Object)((TestMessageProcessor)chain.getMessageProcessors().get(0)).getLabel());
        Assert.assertEquals((Object)"D", (Object)((TestMessageProcessor)chain.getMessageProcessors().get(1)).getLabel());
        MessageProcessor mp = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? (MessageProcessor)((Flow)muleContext.getRegistry().lookupObject("localEndpoints")).getMessageProcessors().get(0) : ((OutboundPassThroughRouter)((OutboundRouterCollection)muleContext.getRegistry().lookupService("localEndpoints").getOutboundMessageProcessor()).getRoutes().get(0)).getRoute("ep4");
        endpoint = (ImmutableEndpoint)mp;
        processors = endpoint.getMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)2L, (long)processors.size());
        Assert.assertEquals((Object)"E", (Object)((TestMessageProcessor)processors.get(0)).getLabel());
        Assert.assertEquals((Object)"F", (Object)((TestMessageProcessor)processors.get(1)).getLabel());
        processors = endpoint.getResponseMessageProcessors();
        Assert.assertNotNull((Object)processors);
        Assert.assertEquals((long)1L, (long)processors.size());
        Assert.assertTrue((boolean)(processors.get(0) instanceof MessageProcessorChain));
        chain = (MessageProcessorChain)processors.get(0);
        Assert.assertEquals((long)2L, (long)chain.getMessageProcessors().size());
        Assert.assertEquals((Object)"G", (Object)((TestMessageProcessor)chain.getMessageProcessors().get(0)).getLabel());
        Assert.assertEquals((Object)"H", (Object)((TestMessageProcessor)chain.getMessageProcessors().get(1)).getLabel());
    }
}

