/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import org.junit.Test;
import org.mule.config.spring.parsers.AbstractNamespaceTestCase;
import org.mule.config.spring.parsers.beans.OrphanBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntryCombinerTestCase
extends AbstractNamespaceTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapEntryCombinerTestCase.class);

    protected String getConfigFile() {
        return "org/mule/config/spring/parsers/map-entry-combiner-test.xml";
    }

    @Test
    public void testProperties() {
        OrphanBean bean = (OrphanBean)this.assertBeanExists("checkProps", OrphanBean.class);
        LOGGER.info("Map size: " + bean.getMap().size());
        this.assertMapEntryExists(bean.getMap(), "0", 0);
    }

    @Test
    public void testCombinedMap() {
        OrphanBean bean = (OrphanBean)this.assertBeanExists("orphan", OrphanBean.class);
        LOGGER.info("Map size: " + bean.getMap().size());
        for (int i = 0; i < 6; ++i) {
            this.assertMapEntryExists(bean.getMap(), Integer.toString(i + 1), i + 1);
        }
    }

    @Test
    public void testReversedOrder() {
        OrphanBean bean = (OrphanBean)this.assertBeanExists("orphan2", OrphanBean.class);
        LOGGER.info("Map size: " + bean.getMap().size());
        for (int i = 0; i < 2; ++i) {
            this.assertMapEntryExists(bean.getMap(), Integer.toString(i + 1), i + 1);
        }
    }
}

