/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.spring.parsers.beans.AbstractBean;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamespaceTestCase
extends FunctionalTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNamespaceTestCase.class);

    @Test
    public void testParse() {
    }

    protected Object assertBeanExists(String name, Class clazz) {
        Object bean = muleContext.getRegistry().lookupObject(name);
        Assert.assertNotNull((String)(name + " bean missing"), (Object)bean);
        Assert.assertTrue((boolean)bean.getClass().equals(clazz));
        LOGGER.debug("found bean " + name + "/" + ClassUtils.getSimpleName(bean.getClass()));
        return bean;
    }

    protected Object assertContentExists(Object object, Class clazz) {
        Assert.assertNotNull((String)(ClassUtils.getSimpleName((Class)clazz) + " content missing"), (Object)object);
        Assert.assertTrue((boolean)clazz.isAssignableFrom(object.getClass()));
        LOGGER.debug("found content " + ClassUtils.getSimpleName(object.getClass()));
        return object;
    }

    protected void assertBeanPopulated(AbstractBean bean, String name) {
        this.assertMapExists(bean.getMap(), name);
        this.assertListExists(bean.getList(), name);
        String string = bean.getString();
        Assert.assertNotNull((String)("string for " + name), (Object)string);
        Assert.assertEquals((Object)(name + "String"), (Object)string);
    }

    protected void assertMapExists(Map map, String name) {
        Assert.assertNotNull((String)("map for " + name), (Object)map);
        this.assertMapEntryExists(map, name, 1);
        this.assertMapEntryExists(map, name, 2);
    }

    protected void assertMapEntryExists(Map map, String name, int index) {
        String key = "key" + index;
        Object value = map.get(key);
        Assert.assertNotNull((String)(key + " returns null"), value);
        Assert.assertTrue((boolean)(value instanceof String));
        Assert.assertEquals((Object)(name + "Map" + index), value);
    }

    protected void assertListExists(List list, String name) {
        Assert.assertNotNull((String)("list for " + name), (Object)list);
        this.assertListEntryExists(list, name, 1);
        this.assertListEntryExists(list, name, 2);
    }

    protected void assertListEntryExists(List list, String name, int index) {
        String value = name + "List" + index;
        Assert.assertTrue((String)value, (boolean)list.contains(value));
    }
}

