/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.flow;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.processor.StageNameSource;
import org.mule.construct.Flow;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.processor.AsyncDelegateMessageProcessor;
import org.mule.processor.strategy.AbstractThreadingProfileProcessingStrategy;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.tck.junit4.FunctionalTestCase;

public class FlowProcessingStrategyConfigTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/config/spring/flow/flow-processing-strategies.xml";
    }

    @Test
    public void testDefault() throws Exception {
        Assert.assertEquals(DefaultFlowProcessingStrategy.class, this.getFlowProcessingStrategy("defaultFlow").getClass());
    }

    @Test
    public void testSynchronous() throws Exception {
        Assert.assertEquals(SynchronousProcessingStrategy.class, this.getFlowProcessingStrategy("synchronousFlow").getClass());
    }

    @Test
    public void testAsynchronous() throws Exception {
        Assert.assertEquals(AsynchronousProcessingStrategy.class, this.getFlowProcessingStrategy("asynchronousFlow").getClass());
    }

    @Test
    public void testQueuedAsynchronous() throws Exception {
        Assert.assertEquals(QueuedAsynchronousProcessingStrategy.class, this.getFlowProcessingStrategy("queuedAsynchronousFlow").getClass());
    }

    @Test
    public void testNonBlocking() throws Exception {
        Assert.assertEquals(NonBlockingProcessingStrategy.class, this.getFlowProcessingStrategy("nonBlockingFlow").getClass());
    }

    @Test
    public void testCustomAsynchronous() throws Exception {
        ProcessingStrategy processingStrategy = this.getFlowProcessingStrategy("customAsynchronousFlow");
        Assert.assertEquals(AsynchronousProcessingStrategy.class, processingStrategy.getClass());
        this.assertAsynchronousStrategyConfig((AbstractThreadingProfileProcessingStrategy)((AsynchronousProcessingStrategy)processingStrategy));
    }

    @Test
    public void testCustomNonBlocking() throws Exception {
        ProcessingStrategy processingStrategy = this.getFlowProcessingStrategy("customNonBlockingFlow");
        Assert.assertEquals(NonBlockingProcessingStrategy.class, processingStrategy.getClass());
        this.assertAsynchronousStrategyConfig((AbstractThreadingProfileProcessingStrategy)processingStrategy);
    }

    @Test
    public void testCustomQueuedAsynchronous() throws Exception {
        ProcessingStrategy processingStrategy = this.getFlowProcessingStrategy("customQueuedAsynchronousFlow");
        Assert.assertEquals(QueuedAsynchronousProcessingStrategy.class, processingStrategy.getClass());
        this.assertAsynchronousStrategyConfig((AbstractThreadingProfileProcessingStrategy)((AsynchronousProcessingStrategy)processingStrategy));
        Assert.assertEquals((long)100L, (long)((QueuedAsynchronousProcessingStrategy)processingStrategy).getQueueTimeout().intValue());
        Assert.assertEquals((long)10L, (long)((QueuedAsynchronousProcessingStrategy)processingStrategy).getMaxQueueSize().intValue());
    }

    @Test
    public void testCustom() throws Exception {
        ProcessingStrategy processingStrategy = this.getFlowProcessingStrategy("customProcessingStrategyFlow");
        Assert.assertEquals(CustomProcessingStrategy.class, processingStrategy.getClass());
        Assert.assertEquals((Object)"bar", (Object)((CustomProcessingStrategy)processingStrategy).foo);
    }

    @Test
    public void testDefaultAsync() throws Exception {
        Assert.assertEquals(QueuedAsynchronousProcessingStrategy.class, this.getAsyncProcessingStrategy("defaultAsync").getClass());
    }

    @Test
    public void testAsynchronousAsync() throws Exception {
        Assert.assertEquals(AsynchronousProcessingStrategy.class, this.getAsyncProcessingStrategy("asynchronousAsync").getClass());
    }

    @Test
    public void testQueuedAsynchronousAsync() throws Exception {
        Assert.assertEquals(QueuedAsynchronousProcessingStrategy.class, this.getAsyncProcessingStrategy("queuedAsynchronousAsync").getClass());
    }

    @Test
    public void testCustomAsynchronousAsync() throws Exception {
        ProcessingStrategy processingStrategy = this.getAsyncProcessingStrategy("customAsynchronousAsync");
        Assert.assertEquals(AsynchronousProcessingStrategy.class, processingStrategy.getClass());
        this.assertAsynchronousStrategyConfig((AbstractThreadingProfileProcessingStrategy)((AsynchronousProcessingStrategy)processingStrategy));
    }

    @Test
    public void testCustomQueuedAsynchronousAsync() throws Exception {
        ProcessingStrategy processingStrategy = this.getAsyncProcessingStrategy("customQueuedAsynchronousAsync");
        Assert.assertEquals(QueuedAsynchronousProcessingStrategy.class, processingStrategy.getClass());
        this.assertAsynchronousStrategyConfig((AbstractThreadingProfileProcessingStrategy)((AsynchronousProcessingStrategy)processingStrategy));
        Assert.assertEquals((long)100L, (long)((QueuedAsynchronousProcessingStrategy)processingStrategy).getQueueTimeout().intValue());
        Assert.assertEquals((long)10L, (long)((QueuedAsynchronousProcessingStrategy)processingStrategy).getMaxQueueSize().intValue());
    }

    @Test
    public void testCustomAsync() throws Exception {
        ProcessingStrategy processingStrategy = this.getAsyncProcessingStrategy("customProcessingStrategyAsync");
        Assert.assertEquals(CustomProcessingStrategy.class, processingStrategy.getClass());
        Assert.assertEquals((Object)"bar", (Object)((CustomProcessingStrategy)processingStrategy).foo);
    }

    private void assertAsynchronousStrategyConfig(AbstractThreadingProfileProcessingStrategy processingStrategy) {
        Assert.assertEquals((long)10L, (long)processingStrategy.getMaxThreads().intValue());
        Assert.assertEquals((long)5L, (long)processingStrategy.getMinThreads().intValue());
        Assert.assertEquals((long)100L, (long)processingStrategy.getThreadTTL().intValue());
        Assert.assertEquals((long)10L, (long)processingStrategy.getMaxBufferSize().intValue());
    }

    private ProcessingStrategy getFlowProcessingStrategy(String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        return flow.getProcessingStrategy();
    }

    private ProcessingStrategy getAsyncProcessingStrategy(String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MessageProcessor processor = (MessageProcessor)flow.getMessageProcessors().get(0);
        Assert.assertEquals(AsyncDelegateMessageProcessor.class, processor.getClass());
        return ((AsyncDelegateMessageProcessor)processor).getProcessingStrategy();
    }

    public static class CustomProcessingStrategy
    implements ProcessingStrategy {
        String foo;

        public void configureProcessors(List<MessageProcessor> processors, StageNameSource nameSource, MessageProcessorChainBuilder chainBuilder, MuleContext muleContext) {
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }
}

