/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.QueueStore;
import org.mule.config.QueueProfile;
import org.mule.construct.Flow;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.model.seda.SedaService;
import org.mule.processor.SedaStageInterceptingMessageProcessor;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.SimpleMemoryObjectStore;

public class QueueStoreConfigurationTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/spring/queue-store-configs.xml";
    }

    @Test
    public void testServiceDefaults() {
        SedaService service = this.lookupService("serviceDefault");
        QueueProfile queueProfile = service.getQueueProfile();
        int expectedQueueSize = service.getThreadingProfile().getMaxThreadsActive() * SedaStageInterceptingMessageProcessor.DEFAULT_QUEUE_SIZE_MAX_THREADS_FACTOR;
        Assert.assertThat((Object)queueProfile.getMaxOutstandingMessages(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedQueueSize)));
        this.assertObjectStoreIsDefaultMemoryObjectStore((ListableObjectStore<Serializable>)queueProfile.getObjectStore());
    }

    @Test
    public void testServiceOnlyNumberOfOutstandingMessagesConfigured() {
        SedaService service = this.lookupService("serviceNoObjectStore");
        QueueProfile queueProfile = service.getQueueProfile();
        Assert.assertEquals((long)42L, (long)queueProfile.getMaxOutstandingMessages());
        this.assertObjectStoreIsDefaultMemoryObjectStore((ListableObjectStore<Serializable>)queueProfile.getObjectStore());
    }

    @Test
    public void testServiceExplicitDefaultMemoryObjectStoreConfigured() {
        SedaService service = this.lookupService("serviceExplicitDefaultMemoryObjectStore");
        QueueProfile queueProfile = service.getQueueProfile();
        this.assertObjectStoreIsDefaultMemoryObjectStore((ListableObjectStore<Serializable>)queueProfile.getObjectStore());
    }

    @Test
    public void testServiceExplicitDefaultPersistentObjectStoreConfigured() {
        SedaService service = this.lookupService("serviceExplicitDefaultPersistentObjectStore");
        QueueProfile queueProfile = service.getQueueProfile();
        this.assertObjectStoreIsDefaultPersistentObjectStore((ListableObjectStore<Serializable>)queueProfile.getObjectStore());
    }

    @Test
    public void testServiceExplicitObjectStoreConfigured() {
        SedaService service = this.lookupService("serviceExplicitObjectStore");
        QueueProfile queueProfile = service.getQueueProfile();
        Assert.assertTrue((boolean)(queueProfile.getObjectStore() instanceof TestQueueStore));
    }

    @Test
    public void testFlowDefaults() {
        Flow flow = this.lookupFlow("flowDefault");
        Assert.assertTrue((boolean)(flow.getProcessingStrategy() instanceof DefaultFlowProcessingStrategy));
    }

    @Test
    public void testFlowQueuedAsync() {
        Flow flow = this.lookupFlow("flowQueuedAsync");
        ProcessingStrategy pipeline = flow.getProcessingStrategy();
        Assert.assertTrue((boolean)(pipeline instanceof QueuedAsynchronousProcessingStrategy));
        QueuedAsynchronousProcessingStrategy queuedPipeline = (QueuedAsynchronousProcessingStrategy)pipeline;
        this.assertObjectStoreIsDefaultMemoryObjectStore((ListableObjectStore<Serializable>)queuedPipeline.getQueueStore());
    }

    @Test
    public void testFlowQueuedAsyncWithPersistentObjectStore() {
        Flow flow = this.lookupFlow("flowQueuedAsyncPersistentStore");
        ProcessingStrategy pipeline = flow.getProcessingStrategy();
        Assert.assertTrue((boolean)(pipeline instanceof QueuedAsynchronousProcessingStrategy));
        QueuedAsynchronousProcessingStrategy queuedPipeline = (QueuedAsynchronousProcessingStrategy)pipeline;
        this.assertObjectStoreIsDefaultPersistentObjectStore((ListableObjectStore<Serializable>)queuedPipeline.getQueueStore());
    }

    private SedaService lookupService(String name) {
        return (SedaService)muleContext.getRegistry().lookupService(name);
    }

    private Flow lookupFlow(String name) {
        return (Flow)muleContext.getRegistry().lookupFlowConstruct(name);
    }

    private void assertObjectStoreIsDefaultMemoryObjectStore(ListableObjectStore<Serializable> objectStore) {
        Object defaultMemoryObjectStore = muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore");
        Assert.assertEquals((Object)defaultMemoryObjectStore, objectStore);
    }

    private void assertObjectStoreIsDefaultPersistentObjectStore(ListableObjectStore<Serializable> objectStore) {
        Object defaultPersistentObjectStore = muleContext.getRegistry().lookupObject("_defaultPersistentQueueStore");
        Assert.assertEquals((Object)defaultPersistentObjectStore, objectStore);
    }

    public static class TestQueueStore
    extends SimpleMemoryObjectStore<Serializable>
    implements QueueStore<Serializable> {
    }
}

