/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.spring.TestLifecycleObject;
import org.mule.tck.junit4.FunctionalTestCase;

public class ManuallyRegisteredObjectLifecycleTestCase
extends FunctionalTestCase {
    private static final String INITIALISABLE = "initialisable";
    private static final String STARTABLE = "startable";

    protected String[] getConfigFiles() {
        return new String[0];
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                muleContext.getRegistry().registerObject("TestInitialisableObject", (Object)new TestInitialisableObject());
                muleContext.getRegistry().registerObject("TestStartableObject", (Object)new TestStartableObject());
            }
        });
    }

    @Test
    public void manuallyRegisteredStartableLifecycle() throws Exception {
        this.assertLifecycle(STARTABLE);
    }

    @Test
    public void manuallyRegisteredInitialisableLifecycle() throws Exception {
        this.assertLifecycle(INITIALISABLE);
    }

    private void assertLifecycle(String key) {
        TestLifecycleObject testLifecycleObject = (TestLifecycleObject)muleContext.getRegistry().get(key);
        Assert.assertThat((Object)testLifecycleObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)testLifecycleObject.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)testLifecycleObject.getStart(), (Matcher)CoreMatchers.is((Object)1));
    }

    private class TestInitialisableObject
    extends RegisteringObject
    implements Initialisable {
        private TestInitialisableObject() {
        }

        public void initialise() throws InitialisationException {
            try {
                this.manuallyRegisterObject();
            }
            catch (MuleException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }

        @Override
        protected String getKey() {
            return ManuallyRegisteredObjectLifecycleTestCase.INITIALISABLE;
        }
    }

    private class TestStartableObject
    extends RegisteringObject
    implements Startable {
        private TestStartableObject() {
        }

        public void start() throws MuleException {
            this.manuallyRegisterObject();
        }

        @Override
        protected String getKey() {
            return ManuallyRegisteredObjectLifecycleTestCase.STARTABLE;
        }
    }

    private abstract class RegisteringObject
    implements MuleContextAware {
        private MuleContext muleContext;

        private RegisteringObject() {
        }

        public void setMuleContext(MuleContext muleContext) {
            this.muleContext = muleContext;
        }

        protected void manuallyRegisterObject() throws MuleException {
            TestLifecycleObject o = new TestLifecycleObject();
            this.muleContext.getRegistry().registerObject(this.getKey(), (Object)o);
        }

        protected abstract String getKey();
    }
}

