/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.serialization.DefaultObjectSerializer;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.serialization.internal.AbstractObjectSerializer;
import org.mule.tck.junit4.FunctionalTestCase;

@RunWith(value=Parameterized.class)
public class InjectDefaultObjectSerializerTestCase
extends FunctionalTestCase {
    private final String name;
    private final String[] configFiles;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Default Serializer", new String[0]}, {"Custom Serializer", new String[]{"custom-object-serializer-config.xml"}});
    }

    public InjectDefaultObjectSerializerTestCase(String name, String[] configFiles) {
        this.name = name;
        this.configFiles = configFiles;
    }

    protected String[] getConfigFiles() {
        return this.configFiles;
    }

    @Test
    public void injectObjectSerializer() throws Exception {
        TestObjectSerializerInjectionTarget injectionTarget = (TestObjectSerializerInjectionTarget)muleContext.getInjector().inject((Object)new TestObjectSerializerInjectionTarget());
        Assert.assertThat((Object)muleContext.getObjectSerializer(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)injectionTarget.getObjectSerializer())));
        Assert.assertThat((Object)injectionTarget.getObjectSerializer(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getRegistry().get("_muleDefaultObjectSerializer"))));
    }

    public static class TestObjectSerializer
    extends AbstractObjectSerializer {
        protected byte[] doSerialize(Object object) throws Exception {
            return new byte[0];
        }

        protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
            return null;
        }
    }

    public static class TestObjectSerializerInjectionTarget {
        @Inject
        @DefaultObjectSerializer
        private ObjectSerializer objectSerializer;

        public ObjectSerializer getObjectSerializer() {
            return this.objectSerializer;
        }
    }
}

