/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.routing.IdempotentSecureHashMessageFilter;
import org.mule.routing.MessageFilter;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.InMemoryObjectStore;
import org.mule.util.store.TextFileObjectStore;

public class CoreNamespaceRoutersServiceTestCase
extends FunctionalTestCase {
    public String getConfigFile() {
        return "core-namespace-routers-service.xml";
    }

    @Test
    public void testIdempotentSecureHashReceiverRouter() throws Exception {
        MessageProcessor router = this.lookupInboundRouterFromService("IdempotentSecureHashReceiverRouter");
        Assert.assertTrue((boolean)(router instanceof IdempotentSecureHashMessageFilter));
        IdempotentSecureHashMessageFilter filter = (IdempotentSecureHashMessageFilter)router;
        Assert.assertEquals((Object)"SHA-128", (Object)filter.getMessageDigestAlgorithm());
        Assert.assertNotNull((Object)filter.getStore());
        Assert.assertTrue((boolean)(filter.getStore() instanceof InMemoryObjectStore));
        InMemoryObjectStore store = (InMemoryObjectStore)filter.getStore();
        Assert.assertEquals((long)1001L, (long)store.getEntryTTL());
        Assert.assertEquals((long)1001L, (long)store.getExpirationInterval());
        Assert.assertEquals((long)1001L, (long)store.getMaxEntries());
        Assert.assertEquals((Object)"xyz", (Object)store.getName());
        Assert.assertNotNull((Object)store.getScheduler());
    }

    @Test
    public void testIdempotentReceiverRouter() throws Exception {
        MessageProcessor router = this.lookupInboundRouterFromService("IdempotentReceiverRouter");
        Assert.assertTrue((boolean)(router instanceof IdempotentMessageFilter));
        IdempotentMessageFilter filter = (IdempotentMessageFilter)router;
        Assert.assertEquals((Object)"#[message:id]-#[message:correlationId]", (Object)filter.getIdExpression());
        Assert.assertNotNull((Object)filter.getStore());
        Assert.assertTrue((boolean)(filter.getStore() instanceof TextFileObjectStore));
        TextFileObjectStore store = (TextFileObjectStore)filter.getStore();
        Assert.assertEquals((long)-1L, (long)store.getEntryTTL());
        Assert.assertEquals((long)1000L, (long)store.getExpirationInterval());
        Assert.assertEquals((long)10000000L, (long)store.getMaxEntries());
        Assert.assertEquals((Object)"foo", (Object)store.getDirectory());
        Assert.assertNotNull((Object)store.getName());
        Assert.assertNotNull((Object)store.getScheduler());
    }

    @Test
    public void testSelectiveConsumerRouter() throws Exception {
        MessageProcessor router = this.lookupInboundRouterFromService("SelectiveConsumerRouter");
        Assert.assertTrue((boolean)(router instanceof MessageFilter));
    }

    @Test
    public void testCustomRouter() throws Exception {
        MessageProcessor router = this.lookupOutboundRouterFromService("CustomRouter");
        Assert.assertTrue((boolean)(router instanceof CustomOutboundRouter));
    }

    protected MessageProcessor lookupOutboundRouterFromService(String serviceName) throws Exception {
        Service service = this.lookupService(serviceName);
        OutboundRouterCollection routerCollection = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        return (MessageProcessor)routerCollection.getRoutes().get(0);
    }

    protected MessageProcessor lookupInboundRouterFromService(String serviceName) throws Exception {
        Service service = this.lookupService(serviceName);
        List routers = ((ServiceCompositeMessageSource)service.getMessageSource()).getMessageProcessors();
        Assert.assertEquals((long)1L, (long)routers.size());
        return (MessageProcessor)routers.get(0);
    }

    protected Service lookupService(String serviceName) {
        Service service = muleContext.getRegistry().lookupService(serviceName);
        Assert.assertNotNull((Object)service);
        return service;
    }

    public static class CustomOutboundRouter
    extends AbstractOutboundRouter {
        public boolean isMatch(MuleMessage message) throws MuleException {
            return true;
        }

        protected MuleEvent route(MuleEvent event) throws MessagingException {
            return event;
        }
    }
}

