/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.annotations.param;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;
import org.mule.util.ExceptionUtils;
import org.mule.util.IOUtils;

public class PayloadAnnotationTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/annotations/payload-annotation-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/annotations/payload-annotation-flow.xml"});
    }

    public PayloadAnnotationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Test
    public void testPayloadNoTransform() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://payload1", (Object)"foo", null);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a String", (boolean)(message.getPayload() instanceof String));
        Assert.assertEquals((Object)"foo", (Object)message.getPayload());
    }

    @Test
    public void testPayloadAutoTransform() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://payload2", (Object)"foo", null);
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a String", (boolean)(message.getPayload() instanceof InputStream));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.toString((InputStream)((InputStream)message.getPayload())));
    }

    @Test
    public void testPayloadFailedTransform() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://payload3", PayloadAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(TransformerException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }
}

