/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.annotations.param;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;
import org.mule.util.ExceptionUtils;

public class OutboundHeadersAnnotationTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/annotations/outbound-headers-annotation-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/annotations/outbound-headers-annotation-flow.xml"});
    }

    public OutboundHeadersAnnotationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Test
    public void testProcessHeader() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://header", OutboundHeadersAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((Object)"barValue", result.get("bar"));
    }

    @Test
    public void testProcessHeaderWithExistingOutHeaders() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://header2", OutboundHeadersAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((String)"return message from MuleClient.send() should not be null", (Object)message);
        Assert.assertTrue((String)"Message payload should be a Map", (boolean)(message.getPayload() instanceof Map));
        Map result = (Map)message.getPayload();
        Assert.assertEquals((Object)"barValue", result.get("bar"));
        Assert.assertEquals((Object)"fooValue", result.get("foo"));
    }

    @Test
    public void testInvalidParamType() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://invalid", OutboundHeadersAnnotationTestCase.getTestMuleMessage((Object)NullPayload.getInstance()));
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(IllegalArgumentException.class, ExceptionUtils.getRootCause((Throwable)message.getExceptionPayload().getException()).getClass());
    }
}

