/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.context.WorkManager;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;

public class NonBlockingWorkManagerTestCase
extends FunctionalTestCase {
    private static final int MAX_THREADS = 2;
    private static final int WAIT_TIME = 1000;

    protected String getConfigFile() {
        return "non-blocking-work-manager-config.xml";
    }

    @Test
    public void executesEverythingWhenDefault() throws InterruptedException {
        List<String> threads = this.runAndCollectThreads("nonBlockingFlow");
        Assert.assertThat(threads, (Matcher)Matchers.hasItems((Object[])new String[]{"nonBlockingFlow.01", "nonBlockingFlow.01"}));
    }

    @Test
    public void executesOnCallerWhenRun() throws InterruptedException {
        List<String> threads = this.runAndCollectThreads("customNonBlockingFlow");
        Assert.assertThat(threads, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"customNonBlockingFlow.01", Thread.currentThread().getName()}));
    }

    private List<String> runAndCollectThreads(String flowName) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(2);
        final LinkedList<String> threads = new LinkedList<String>();
        WorkManager workManager = ((Flow)muleContext.getRegistry().lookupFlowConstruct(flowName)).getWorkManager();
        for (int i = 0; i < 2; ++i) {
            workManager.execute(new Runnable(){

                @Override
                public void run() {
                    threads.add(Thread.currentThread().getName());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    latch.countDown();
                }
            });
        }
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat(threads, (Matcher)Matchers.hasSize((int)2));
        return threads;
    }
}

