/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;

public class NonBlockingFullySupportedOneWayFunctionalTestCase
extends FunctionalTestCase {
    public static String FOO = "foo";

    protected String getConfigFile() {
        return "non-blocking-fully-supported-oneway-test-config.xml";
    }

    @Test
    public void flow() throws Exception {
        this.assertVoidMuleEventResponse("flow");
    }

    @Test
    public void subFlow() throws Exception {
        this.assertVoidMuleEventResponse("subFlow");
    }

    @Test
    public void childFlow() throws Exception {
        this.assertVoidMuleEventResponse("childFlow");
        FlowAssert.verify((String)"childFlowChild");
    }

    @Test
    public void childDefaultFlow() throws Exception {
        this.testFlow("childDefaultFlow", MessageExchangePattern.ONE_WAY);
        FlowAssert.verify((String)"childDefaultFlowChild");
    }

    @Test
    public void childSyncFlow() throws Exception {
        this.testFlow("childSyncFlow", MessageExchangePattern.ONE_WAY);
        FlowAssert.verify((String)"childSyncFlowChild");
    }

    @Test(expected=MessagingException.class)
    public void childAsyncFlow() throws Exception {
        this.testFlow("childAsyncFlow", MessageExchangePattern.ONE_WAY);
        FlowAssert.verify((String)"childAsyncFlowChild");
    }

    @Test(expected=MessagingException.class)
    public void childQueuedAsyncFlow() throws Exception {
        Assert.assertThat((Object)this.testFlow("childQueuedAsyncFlow", MessageExchangePattern.ONE_WAY), (Matcher)CoreMatchers.instanceOf(DefaultMuleEvent.class));
        FlowAssert.verify((String)"childQueuedAsyncFlowChild");
    }

    @Test
    public void processorChain() throws Exception {
        this.assertVoidMuleEventResponse("processorChain");
    }

    @Test
    public void filterAccepts() throws Exception {
        this.assertVoidMuleEventResponse("filterAccepts");
    }

    @Test
    public void filterRejects() throws Exception {
        Assert.assertThat((Object)this.testFlow("filterRejects", MessageExchangePattern.ONE_WAY), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void filterAfterNonBlockingAccepts() throws Exception {
        this.assertVoidMuleEventResponse("filterAfterNonBlockingAccepts");
    }

    @Test
    public void filterAfterNonBlockingRejects() throws Exception {
        this.assertVoidMuleEventResponse("filterAfterNonBlockingRejects");
    }

    @Test
    public void filterBeforeNonBlockingAccepts() throws Exception {
        this.assertVoidMuleEventResponse("filterAfterNonBlockingAccepts");
    }

    @Test
    public void filterBeforeNonBlockingRejects() throws Exception {
        Assert.assertThat((Object)this.testFlow("filterBeforeNonBlockingRejects", MessageExchangePattern.ONE_WAY), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void filterAfterEnricherBeforeNonBlocking() throws Exception {
        Assert.assertThat((Object)this.testFlow("filterAfterEnricherBeforeNonBlocking", MessageExchangePattern.ONE_WAY), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void securityFilter() throws Exception {
        this.assertVoidMuleEventResponse("security-filter");
    }

    @Test
    public void transformer() throws Exception {
        this.assertVoidMuleEventResponse("transformer");
    }

    @Test
    public void choice() throws Exception {
        this.assertVoidMuleEventResponse("choice");
    }

    @Test
    public void enricher() throws Exception {
        this.assertVoidMuleEventResponse("enricher");
    }

    @Test
    public void enricherIssue() throws Exception {
        this.assertVoidMuleEventResponse("enricherIssue");
    }

    @Test
    public void enricherIssueNonBlocking() throws Exception {
        this.assertVoidMuleEventResponse("enricherIssueNonBlocking");
    }

    @Test
    public void enricherFlowVar() throws Exception {
        this.assertVoidMuleEventResponse("enricherFlowVar");
    }

    @Test
    public void testTransportOutboundEndpoint() throws Exception {
        this.assertVoidMuleEventResponse("testOutboundEndpoint");
    }

    @Test
    public void testTransportOutboundEndpointError() throws Exception {
        this.assertVoidMuleEventResponse("testOutboundEndpointError");
    }

    @Test
    public void async() throws Exception {
        this.assertVoidMuleEventResponse("async");
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        this.assertVoidMuleEventResponse("catchExceptionStrategy");
        FlowAssert.verify((String)"catchExceptionStrategyChild");
    }

    private void assertVoidMuleEventResponse(String flowName) throws Exception {
        Assert.assertThat((Object)this.testFlow(flowName, MessageExchangePattern.ONE_WAY), (Matcher)CoreMatchers.instanceOf(VoidMuleEvent.class));
    }
}

