/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.security.Permission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.MuleServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.ClassUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.JdkVersionUtils;

public class MuleServerTestCase
extends AbstractMuleTestCase {
    private static String originalConfigBuilderClassName = MuleServer.getConfigBuilderClassName();
    private MuleServer muleServer;

    @After
    public void restoreOriginalConfigBuilderClassName() throws Exception {
        if (this.muleServer != null) {
            this.muleServer.shutdown();
        }
        MuleServer.setConfigBuilderClassName((String)originalConfigBuilderClassName);
    }

    @Test
    public void testMuleServer() throws Exception {
        this.muleServer = new MuleServer(){

            public void shutdown() {
                this.doShutdown();
            }
        };
        Assert.assertEquals((Object)ClassUtils.getResource((String)"mule-config.xml", MuleServer.class).toString(), (Object)this.muleServer.getConfigurationResources());
        Assert.assertEquals((Object)"org.mule.config.builders.AutoConfigurationBuilder", (Object)MuleServer.getConfigBuilderClassName());
        this.muleServer.initialize();
    }

    @Test
    public void testMuleServerResource() throws Exception {
        this.muleServer = new MuleServer("org/mule/test/spring/config1/test-xml-mule2-config.xml"){

            public void shutdown() {
                this.doShutdown();
            }
        };
        Assert.assertEquals((Object)"org/mule/test/spring/config1/test-xml-mule2-config.xml", (Object)this.muleServer.getConfigurationResources());
        Assert.assertEquals((Object)"org.mule.config.builders.AutoConfigurationBuilder", (Object)MuleServer.getConfigBuilderClassName());
        this.muleServer.initialize();
    }

    @Test
    public void testMuleServerConfigArg() throws Exception {
        this.muleServer = new MuleServer(new String[]{"-config", "org/mule/test/spring/config1/test-xml-mule2-config.xml"}){

            public void shutdown() {
                this.doShutdown();
            }
        };
        Assert.assertEquals((Object)"org/mule/test/spring/config1/test-xml-mule2-config.xml", (Object)this.muleServer.getConfigurationResources());
        Assert.assertEquals((Object)"org.mule.config.builders.AutoConfigurationBuilder", (Object)MuleServer.getConfigBuilderClassName());
        this.muleServer.initialize();
    }

    @Test
    public void testMuleServerMultipleSpringConfigArgs() throws Exception {
        this.muleServer = new MuleServer(new String[]{"-config", "mule-config.xml,org/mule/test/spring/config1/test-xml-mule2-config.xml"}){

            public void shutdown() {
                this.doShutdown();
            }
        };
        Assert.assertEquals((Object)"mule-config.xml,org/mule/test/spring/config1/test-xml-mule2-config.xml", (Object)this.muleServer.getConfigurationResources());
        Assert.assertEquals((Object)"org.mule.config.builders.AutoConfigurationBuilder", (Object)MuleServer.getConfigBuilderClassName());
        this.muleServer.initialize();
    }

    @Test
    public void testMuleServerBuilerArg() throws Exception {
        this.muleServer = new MuleServer(new String[]{"-builder", "org.mule.config.spring.SpringXmlConfigurationBuilder"}){

            public void shutdown() {
                this.doShutdown();
            }
        };
        Assert.assertEquals((Object)ClassUtils.getResource((String)"mule-config.xml", MuleServer.class).toString(), (Object)this.muleServer.getConfigurationResources());
        Assert.assertEquals((Object)"org.mule.config.spring.SpringXmlConfigurationBuilder", (Object)MuleServer.getConfigBuilderClassName());
        this.muleServer.initialize();
    }

    @Test
    public void testMuleServerSpringBuilerArg() throws Exception {
        this.muleServer = new MuleServer(new String[]{"-builder", "spring"}){

            public void shutdown() {
                this.doShutdown();
            }
        };
        Assert.assertEquals((Object)ClassUtils.getResource((String)"mule-config.xml", MuleServer.class).toString(), (Object)this.muleServer.getConfigurationResources());
        Assert.assertEquals((Object)"org.mule.config.spring.SpringXmlConfigurationBuilder", (Object)MuleServer.getConfigBuilderClassName());
        this.muleServer.initialize();
    }

    @Ignore(value="MULE-6926: Flaky test - fails on build server")
    @Test
    public void testMuleServerAppConfig() throws Exception {
        this.muleServer = new MuleServer(new String[]{"-config", "mule-config.xml", "-appconfig", "org/mule/test/spring/config1/test-app-config.properties"}){

            public void shutdown() {
                this.doShutdown();
            }
        };
        this.muleServer.initialize();
        String workingDirectory = MuleServer.muleContext.getConfiguration().getWorkingDirectory();
        Assert.assertTrue((boolean)FilenameUtils.separatorsToUnix((String)workingDirectory).endsWith("/target/.appT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExitException.class)
    public void testMuleServerJdkVersion() {
        String javaVersion = System.setProperty("java.version", "1.5.0_12");
        try {
            try {
                JdkVersionUtils.validateJdk();
                Assert.fail((String)"Test is invalid because the Jdk version or vendor is supposed to now be invalid");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            SecurityManager manager = System.getSecurityManager();
            try {
                System.setSecurityManager(new NoExitSecurityManager());
                this.muleServer = new MuleServer(){

                    public void shutdown() {
                        this.doShutdown();
                    }
                };
                Assert.fail((String)"Jdk Version is invalid");
            }
            finally {
                System.setSecurityManager(manager);
            }
        }
        finally {
            System.setProperty("java.version", javaVersion);
        }
    }

    private static class ExitException
    extends SecurityException {
        public final int status;

        public ExitException(int status) {
            this.status = status;
        }
    }

    private static final class NoExitSecurityManager
    extends SecurityManager {
        private NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ExitException(status);
        }
    }
}

