/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.test.filters.FilterCounter;

public class Mule4412TestCase
extends AbstractServiceAndFlowTestCase {
    private int RECEIVE_TIMEOUT_MS = 3000;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mule-4412-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mule-4412-flow.xml"});
    }

    public Mule4412TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FilterCounter.counter.set(0);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        FilterCounter.counter.set(0);
    }

    @Test
    public void testFilterOnce() throws Exception {
        MuleMessage msg = Mule4412TestCase.getTestMuleMessage((Object)"Test Message");
        msg.setOutboundProperty("pass", (Object)"true");
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://async", msg);
        MuleMessage reply = client.request("vm://asyncResponse", (long)this.RECEIVE_TIMEOUT_MS);
        int times = FilterCounter.counter.get();
        Assert.assertTrue((String)("did not filter one time as expected, times filtered " + times), (times == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((String)("wrong message received : " + reply.getPayloadAsString()), (Object)"Test Message", (Object)reply.getPayloadAsString());
        Assert.assertEquals((String)"'pass' property value not correct", (Object)"true", (Object)reply.getInboundProperty("pass"));
        Assert.assertNull((Object)client.request("vm://asyncResponse", (long)this.RECEIVE_TIMEOUT_MS));
    }

    @Test
    public void testWrongPropertyKey() throws Exception {
        MuleMessage msg = Mule4412TestCase.getTestMuleMessage((Object)"Test Message");
        msg.setProperty("fail", (Object)"true", PropertyScope.INVOCATION);
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://async", msg);
        MuleMessage reply = client.request("vm://asyncResponse", (long)this.RECEIVE_TIMEOUT_MS);
        Assert.assertNull((Object)reply);
        Assert.assertTrue((String)"should not have filtered", (FilterCounter.counter.get() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWrongPropertyValue() throws Exception {
        MuleMessage msg = Mule4412TestCase.getTestMuleMessage((Object)"Test Message");
        msg.setProperty("pass", (Object)"false", PropertyScope.INBOUND);
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://async", msg);
        MuleMessage reply = client.request("vm://asyncResponse", (long)this.RECEIVE_TIMEOUT_MS);
        Assert.assertNull((Object)reply);
        Assert.assertTrue((String)"should not have filtered", (FilterCounter.counter.get() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNoProperty() throws Exception {
        MuleMessage msg = Mule4412TestCase.getTestMuleMessage((Object)"Test Message");
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://async", msg);
        MuleMessage reply = client.request("vm://asyncResponse", (long)this.RECEIVE_TIMEOUT_MS);
        Assert.assertNull((Object)reply);
        Assert.assertTrue((String)"should not have filtered", (FilterCounter.counter.get() == 0 ? 1 : 0) != 0);
    }
}

