/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.tck.MuleTestUtils;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties error scenarios")
public class ConfigurationPropertiesErrorScenariosTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Description(value="Validates the exception message when the configuration-properties element is pointing to a non existent file")
    @Test
    public void nonExistentFile() throws Exception {
        this.expectedException.expectMessage(ArgumentMatchers.contains((String)"Couldn't find configuration properties file non-existent.properties neither on classpath or in file system"));
        this.loadConfiguration("org/mule/test/components/non-existent-configuration-properties-file.xml");
    }

    @Description(value="Validates the exception message when the configuration-properties element is pointing to a non existent file defined with a system property")
    @Test
    public void nonExistentFileDefinedWithSystemProperty() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"env", (Object)"no-env", () -> {
            this.expectedException.expectMessage("Couldn't find resource: no-env.properties");
            this.loadConfiguration("org/mule/test/components/customizable-configuration-properties-file.xml");
        });
    }

    @Description(value="Validates the exception message when the configuration-properties element points has a file attribute with a placeholder that could not be resolved")
    @Test
    public void fileReferenceWithNoValuePlaceholder() throws Exception {
        this.expectedException.expectMessage(ArgumentMatchers.contains((String)"Couldn't find configuration property value for key ${env} from properties provider system properties provider"));
        this.loadConfiguration("org/mule/test/components/customizable-configuration-properties-file.xml");
    }
}

