/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.processors;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.core.api.config.ConfigurationException;

@Issue(value="W-14642249")
@Feature(value="Core Components")
@Stories(value={@Story(value="Mule DSL Validations"), @Story(value="Max concurrency")})
public class MaxConcurrencyFailuresTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void flowNegativeMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/flow-max-concurrency-negative.xml:8]: Parameter 'maxConcurrency' in element <flow> value '-1' is not within expected range."));
        this.loadConfiguration("org/mule/processors/flow-max-concurrency-negative.xml");
    }

    @Test
    public void flowZeroMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/flow-max-concurrency-zero.xml:8]: Parameter 'maxConcurrency' in element <flow> value '0' is not within expected range."));
        this.loadConfiguration("org/mule/processors/flow-max-concurrency-zero.xml");
    }

    @Test
    public void asyncNegativeMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/async-max-concurrency-negative.xml:9]: Parameter 'maxConcurrency' in element <async> value '-1' is not within expected range."));
        this.loadConfiguration("org/mule/processors/async-max-concurrency-negative.xml");
    }

    @Test
    public void asyncZeroMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/async-max-concurrency-zero.xml:9]: Parameter 'maxConcurrency' in element <async> value '0' is not within expected range."));
        this.loadConfiguration("org/mule/processors/async-max-concurrency-zero.xml");
    }

    @Test
    public void scatterGatherNegativeMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/scatter-gather-max-concurrency-negative.xml:9]: Parameter 'maxConcurrency' in element <scatter-gather> value '-1' is not within expected range."));
        this.loadConfiguration("org/mule/processors/scatter-gather-max-concurrency-negative.xml");
    }

    @Test
    public void scatterGatherZeroMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/scatter-gather-max-concurrency-zero.xml:9]: Parameter 'maxConcurrency' in element <scatter-gather> value '0' is not within expected range."));
        this.loadConfiguration("org/mule/processors/scatter-gather-max-concurrency-zero.xml");
    }

    @Test
    public void parallelforeachNegativeMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/parallel-foreach-max-concurrency-negative.xml:9]: Parameter 'maxConcurrency' in element <parallel-foreach> value '-1' is not within expected range."));
        this.loadConfiguration("org/mule/processors/parallel-foreach-max-concurrency-negative.xml");
    }

    @Test
    public void parallelforeachZeroMaxConcurrency() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"[org/mule/processors/parallel-foreach-max-concurrency-zero.xml:9]: Parameter 'maxConcurrency' in element <parallel-foreach> value '0' is not within expected range."));
        this.loadConfiguration("org/mule/processors/parallel-foreach-max-concurrency-zero.xml");
    }
}

