/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;

@Feature(value="Error Handling")
@Story(value="Mule DSL Validations")
public class ErrorHandlingConfigurationFailuresTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void defaultErrorHandlerReferencesNonExistentErrorHandler() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"No global error handler defined with name 'nonExistentEh'."));
        this.loadConfiguration("org/mule/test/integration/exceptions/default-error-handler-reference-non-existent-es.xml");
    }

    @Test
    public void xaTransactionalTryNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Unable to create Try Scope with a Transaction Type: [XA]"));
        this.loadConfiguration("org/mule/test/integration/transaction/xa-transactional-try-config.xml");
    }

    @Test
    public void xaTransactionalTryNotAllowedWithGlobalErrorHandler() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Unable to create Try Scope with a Transaction Type: [XA]"));
        this.loadConfiguration("org/mule/test/integration/transaction/xa-transactional-try-config-global-err.xml");
    }

    @Test
    public void unknownErrorFilteringNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)this.notFound("UNKNOWN")));
        this.loadConfiguration("org/mule/test/integration/exceptions/unknown-error-filtering-config.xml");
    }

    @Test
    public void sourceErrorResponseFilteringNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)this.notFound("SOURCE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-filtering-config.xml");
    }

    @Test
    public void raisesErrorEmptyErrorTypeNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"The value '' of attribute 'type' on element 'raise-error' is not valid with respect to its type, 'nonBlankString'"));
        this.loadConfiguration("org/mule/test/integration/exceptions/raise-error-empty-type-config.xml");
    }

    @Test
    @Issue(value="W-11802232")
    public void raisesErrorPropertyErrorTypeNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Couldn't find configuration property value for key ${error.type}"));
        this.loadConfiguration("org/mule/test/integration/exceptions/raise-error-property-type-config.xml");
    }

    @Test
    public void sourceErrorResponseSendFilteringNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)this.notFound("SOURCE_ERROR_RESPONSE_SEND")));
        this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-send-filtering-config.xml");
    }

    @Test
    public void sourceErrorResponseGenerateFilteringNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)this.notFound("SOURCE_ERROR_RESPONSE_GENERATE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-generate-filtering-config.xml");
    }

    @Test
    public void criticalErrorFilteringNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)this.notFound("CRITICAL")));
        this.loadConfiguration("org/mule/test/integration/exceptions/critical-error-filtering-config.xml");
    }

    @Test
    public void nonExistingSourceMappingNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Could not find error 'NON_EXISTING'"));
        this.loadConfiguration("org/mule/test/integration/exceptions/non-existing-source-mapping-config.xml");
    }

    @Test
    public void nonExistingCoreMappingsNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"There's no MULE error named 'NON_EXISTING'"));
        this.loadConfiguration("org/mule/test/integration/exceptions/non-existent-core-mapping-config.xml");
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyErrorMappingsSourceNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Couldn't find configuration property value for key ${error.type}"));
        this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-source-config.xml");
    }

    @Test
    @Issue(value="W-11802232")
    public void propertyErrorMappingsTargetNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Couldn't find configuration property value for key ${error.type}"));
        this.loadConfiguration("org/mule/test/integration/exceptions/property-error-mapping-target-config.xml");
    }

    @Test
    public void usedNamespaceMappingsNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Cannot use error type 'HTTP:NOT_FOUND': namespace already exists"));
        this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-mappings-config.xml");
    }

    @Test
    public void usedNamespaceNonExistentTypeMappingsNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Cannot use error type 'HTTP:NONEXISTENT': namespace already exists"));
        this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-nonexistent-type-mappings-config.xml");
    }

    @Test
    public void nonExistingCoreErrorCannotBeRaised() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"There's no MULE error named 'NONEXISTENT'"));
        this.loadConfiguration("org/mule/test/integration/exceptions/non-existent-core-raise-error-config.xml");
    }

    @Test
    public void usedNamespaceErrorCannotBeRaised() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Cannot use error type 'HTTP:TIMEOUT': namespace already exists"));
        this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-raise-error-config.xml");
    }

    @Test
    public void usedNamespaceNonExistentTypeErrorCannotBeRaised() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Cannot use error type 'HTTP:NOT_FOUND': namespace already exists."));
        this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-nonexistent-type-raise-error-config.xml");
    }

    @Test
    public void sourceResponseGenerateOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE_GENERATE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-generate.xml");
    }

    @Test
    public void sourceResponseSendOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE_SEND")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-send.xml");
    }

    @Test
    public void sourceResponseErrorOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-error.xml");
    }

    @Test
    public void sourceErrorInListOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-source-error-list.xml");
    }

    private String notFound(String type) {
        return String.format("Could not find error '%s'", type);
    }

    private String notAllowed(String type) {
        return String.format("Source errors are not allowed in 'on-error-continue' handlers. Offending type is '%s'.", type);
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel sockets = this.loadExtension(SocketsExtension.class, Collections.emptySet());
        ExtensionModel http = this.loadExtension(HttpConnector.class, Collections.singleton(sockets));
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(http);
        extensions.add(sockets);
        return extensions;
    }

    protected void applyConfiguration(DefaultMuleConfiguration muleConfiguration) {
        super.applyConfiguration(muleConfiguration);
        muleConfiguration.setMinMuleVersion(new MuleVersion("4.5.0"));
    }
}

