/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers;

import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.tests.api.TestComponentsExtension;

@Story(value="Mule DSL Validations")
public class XmlDslProcessingValidationTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void parameterAndChildAtOnce() throws Exception {
        String configFile = "org/mule/config/spring/parsers/dsl-validation-duplicate-pojo-or-list-parameter-config.xml";
        this.expectedException.expectMessage("[" + configFile + ":9]: Component 'test-components:element-with-attribute-and-child' has a child element 'test-components:my-pojo' which is used for the same purpose of the configuration parameter 'myPojo'. Only one must be used.");
        this.loadConfiguration(configFile);
    }

    @Test
    public void emptyChildSimpleParameter() throws Exception {
        String configFile = "org/mule/config/spring/parsers/dsl-validation-empty-simple-child-parameter.xml";
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[" + configFile + ":9]: Element <test-components:text-pojo> is missing required parameter 'text'.");
        this.loadConfiguration(configFile);
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel testComponents = this.loadExtension(TestComponentsExtension.class, Collections.emptySet());
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.add(testComponents);
        return extensions;
    }
}

