/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;

@Story(value="Mule DSL Validations")
public class ImportValidationTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void failureOnInvalidImport() throws Exception {
        String configFile = "org/mule/config/spring/parsers/dsl-validation-invalid-import-config.xml";
        this.expectedException.expectMessage("[" + configFile + ":7]: Could not find imported resource 'invalid_location.xml'");
        this.loadConfiguration(configFile);
    }

    @Test
    @Issue(value="W-15509819")
    public void failureOnImportWithDifferentArtifactType() throws Exception {
        String configFile = "org/mule/config/spring/parsers/dsl-validation-different-artifact-type-import-config.xml";
        this.expectedException.expectMessage("[" + configFile + ":7]: Imported resource 'org/mule/config/spring/parsers/dsl-validation-different-artifact-type-imported-config.xml' declares a 'DOMAIN', not a 'APPLICATION'");
        this.loadConfiguration(configFile);
    }

    protected void applyConfiguration(DefaultMuleConfiguration muleConfiguration) {
        super.applyConfiguration(muleConfiguration);
        muleConfiguration.setMinMuleVersion(new MuleVersion("4.8.0"));
    }
}

