/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.ConfigurationException;

@Issue(value="MULE-18770")
@Feature(value="Correlation ID")
@Story(value="Mule DSL Validations")
public class SourceCorrelationIdErrorGenerationTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void errorStaticValue() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"A static value (''doge'') was given for parameter 'correlationIdGeneratorExpression' but it requires an expression"));
        this.loadConfiguration("org/mule/test/config/correlation-id/static-generation.xml");
    }

    @Test
    public void invalidExpression() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"Invalid Correlation ID Generation expression: #['some]"));
        this.loadConfiguration("org/mule/test/config/correlation-id/error-generation.xml");
    }
}

