/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class FileContainsRegex
extends TypeSafeMatcher<File> {
    private final Pattern pattern;

    public static Matcher<File> matchesRegex(String fileLocation) {
        return new FileContainsRegex(fileLocation);
    }

    private FileContainsRegex(String regex) {
        this.pattern = Pattern.compile(regex, 32);
    }

    public void describeTo(Description description) {
        description.appendText("Could not find a match between the provided file and the regex" + this.pattern.pattern());
    }

    public boolean matchesSafely(File file) {
        try {
            String fileContent = new String(Files.readAllBytes(file.toPath()));
            return this.pattern.matcher(fileContent).matches();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

