/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.test.infrastructure.process.MuleProcessController;

public class Running
extends TypeSafeMatcher<MuleProcessController> {
    private boolean isRunning;

    public Running(boolean status) {
        this.isRunning = status;
    }

    public boolean matchesSafely(MuleProcessController mule) {
        try {
            return this.isRunning == mule.isRunning();
        }
        catch (Error e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a Mule Standalone server that is " + (this.isRunning ? "" : "not ") + "running");
    }

    @Factory
    public static <T> Matcher<MuleProcessController> isRunning() {
        return new Running(true);
    }

    @Factory
    public static <T> Matcher<MuleProcessController> notRunning() {
        return new Running(false);
    }
}

