/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.junit.rules.ExternalResource;

public class MuleInstallation
extends ExternalResource {
    private static final File WORKING_DIRECTORY = new File(System.getProperty("user.dir"));
    private static final int BUFFER = 2048;
    private File distribution;
    private File muleHome;

    public MuleInstallation(String zippedDistribution) {
        this.distribution = new File(zippedDistribution);
        if (!this.distribution.exists()) {
            throw new IllegalArgumentException("Packed distribution not found: " + this.distribution);
        }
    }

    public String getMuleHome() {
        return this.muleHome.getAbsolutePath();
    }

    protected void before() throws Throwable {
        this.unzip(this.distribution, WORKING_DIRECTORY);
    }

    protected void after() {
        try {
            FileUtils.deleteDirectory((File)this.muleHome);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't delete directory [" + this.muleHome + "], delete it manually.", e);
        }
    }

    private void unzip(File file, File destDir) throws IOException {
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        ZipEntry root = zipFileEntries.nextElement();
        this.muleHome = new File(destDir, root.getName());
        this.muleHome.mkdirs();
        this.chmodRwx(this.muleHome);
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            File destFile = new File(entry.getName());
            if (entry.isDirectory()) {
                destFile.mkdir();
                continue;
            }
            FileUtils.copyInputStreamToFile((InputStream)zip.getInputStream(entry), (File)destFile);
            this.chmodRwx(destFile);
        }
    }

    private void chmodRwx(File destFile) {
        destFile.setExecutable(true, false);
        destFile.setWritable(true, false);
        destFile.setReadable(true, false);
    }
}

