/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util.ftp;

import java.io.File;
import java.io.IOException;
import org.apache.ftpserver.ftplet.Ftplet;
import org.mule.tck.util.ftp.FtpClient;
import org.mule.tck.util.ftp.MuleFtplet;
import org.mule.tck.util.ftp.Server;
import org.mule.util.FileUtils;

public class FtpServer {
    public static final String FTP_SERVER_BASE_DIR = "target/ftpserver";
    private String ftpHost;
    private int ftpPort;
    private String ftpUser;
    private String ftpPassword;
    private Server server;
    private FtpClient ftpClient;
    private Ftplet ftplet = new MuleFtplet(new MuleFtplet.Callback(){

        @Override
        public void fileUploadCompleted() {
        }

        @Override
        public void fileMoveCompleted() {
        }
    });

    public FtpServer(String ftpHost, int ftpPort, String ftpUser, String ftpPassword) {
        this.ftpHost = ftpHost;
        this.ftpPort = ftpPort;
        this.ftpUser = ftpUser;
        this.ftpPassword = ftpPassword;
    }

    public void start() throws Exception {
        this.ftpClient = new FtpClient(this.ftpHost, this.ftpPort, this.ftpUser, this.ftpPassword);
        this.createFtpServerBaseDir();
        this.startServer();
        if (!this.ftpClient.testConnection()) {
            throw new IOException("could not connect to ftp server");
        }
    }

    public void stop() throws Exception {
        Thread.sleep(500L);
        this.ftpClient.disconnect();
        this.stopServer();
        this.deleteFtpServerBaseDir();
    }

    public FtpClient getFtpClient() {
        return this.ftpClient;
    }

    private void createFtpServerBaseDir() {
        this.deleteFtpServerBaseDir();
        File ftpBaseDir = new File(FTP_SERVER_BASE_DIR);
        ftpBaseDir.mkdirs();
    }

    private void deleteFtpServerBaseDir() {
        File ftpServerBase = new File(FTP_SERVER_BASE_DIR);
        FileUtils.deleteTree((File)ftpServerBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer() throws Exception {
        this.server = new Server(this.ftpPort, this.ftplet);
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            this.wait(500L);
        }
    }

    private void stopServer() throws Exception {
        if (null != this.server) {
            this.server.stop();
        }
    }
}

