/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.listener;

import com.google.common.base.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.NotificationException;
import org.mule.util.Preconditions;
import org.mule.util.concurrent.Latch;

public class ConnectionListener {
    private CountDownLatch notificationReceivedLatch = new Latch();
    private int timeout = 10000;
    private Optional<Long> previousNotificationTimestamp = Optional.absent();
    private Optional<Long> minimumTimeBetweenNotifications = Optional.absent();
    private int expectedAction = 701;

    public ConnectionListener(MuleContext muleContext) {
        try {
            muleContext.registerListener((ServerNotificationListener)new ConnectionNotificationListener<ConnectionNotification>(){

                public void onNotification(ConnectionNotification notification) {
                    if (notification.getAction() == ConnectionListener.this.expectedAction) {
                        long currentNotificationTimestamp = System.currentTimeMillis();
                        if (ConnectionListener.this.previousNotificationTimestamp.isPresent()) {
                            long timeBetweenNotifications = currentNotificationTimestamp - (Long)ConnectionListener.this.previousNotificationTimestamp.get();
                            if (!ConnectionListener.this.minimumTimeBetweenNotifications.isPresent() || (Long)ConnectionListener.this.minimumTimeBetweenNotifications.get() > timeBetweenNotifications) {
                                ConnectionListener.this.minimumTimeBetweenNotifications = Optional.of((Object)timeBetweenNotifications);
                            }
                        }
                        ConnectionListener.this.previousNotificationTimestamp = Optional.of((Object)currentNotificationTimestamp);
                        ConnectionListener.this.notificationReceivedLatch.countDown();
                    }
                }
            });
        }
        catch (NotificationException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilNotificationsAreReceived() {
        try {
            if (!this.notificationReceivedLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Expected notifications were not received");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionListener setNumberOfExecutionsRequired(int numberOfExecutionsRequired) {
        this.notificationReceivedLatch = new CountDownLatch(numberOfExecutionsRequired);
        return this;
    }

    public ConnectionListener setTimeoutInMillis(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ConnectionListener setExpectedAction(int expectedAction) {
        this.expectedAction = expectedAction;
        return this;
    }

    public ConnectionListener reset() {
        this.notificationReceivedLatch = new Latch();
        return this;
    }

    public void assertMinimumTimeBetweenNotifications(long expectedTimeBetweenNotifications) {
        Preconditions.checkState((boolean)this.minimumTimeBetweenNotifications.isPresent(), (String)"At least two notifications must be received in order to get the minimum time between notifications");
        Assert.assertThat((Object)this.minimumTimeBetweenNotifications.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(expectedTimeBetweenNotifications)));
    }
}

