/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.service.scheduler.internal.DefaultSchedulerService;
import org.mule.tck.TriggerableMessageSource;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import reactor.core.publisher.Mono;

@State(value=Scope.Benchmark)
@Warmup(iterations=10)
@Measurement(iterations=10)
public abstract class AbstractFlowBenchmark
extends AbstractBenchmark {
    static final Processor nullProcessor = event -> event;
    static final Processor cpuLightProcessor = event -> {
        Blackhole.consumeCPU((long)10000L);
        return event;
    };
    static final Processor cpuLight2Processor = event -> {
        Blackhole.consumeCPU((long)25000L);
        return event;
    };
    static final Processor cpuIntensiveProcessor = new Processor(){

        public CoreEvent process(CoreEvent event) throws MuleException {
            Blackhole.consumeCPU((long)2500000L);
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
        }
    };
    static final Processor blockingProcessor = new Processor(){

        public CoreEvent process(CoreEvent event) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
    };
    static final Processor blocking2Processor = new Processor(){

        public CoreEvent process(CoreEvent event) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
    };
    static final Processor iorwXSmall = new Processor(){

        public CoreEvent process(CoreEvent event) {
            Blackhole.consumeCPU((long)5000L);
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
    };
    static final Processor iorwSmall = new Processor(){

        public CoreEvent process(CoreEvent event) {
            for (int i = 0; i < 5; ++i) {
                Blackhole.consumeCPU((long)5000L);
                LockSupport.parkNanos(100000L);
            }
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
    };
    static final Processor iorwMedium = new Processor(){

        public CoreEvent process(CoreEvent event) {
            for (int i = 0; i < 20; ++i) {
                Blackhole.consumeCPU((long)5000L);
                LockSupport.parkNanos(100000L);
            }
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
    };
    static final Processor iorwLarge = new Processor(){

        public CoreEvent process(CoreEvent event) {
            for (int i = 0; i < 100; ++i) {
                Blackhole.consumeCPU((long)5000L);
                LockSupport.parkNanos(100000L);
            }
            return event;
        }

        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
    };
    protected MuleContext muleContext;
    protected Flow flow;
    protected TriggerableMessageSource source;
    private DefaultSchedulerService schedulerService;
    @Param(value={"org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory", "org.mule.runtime.core.internal.processor.strategy.ReactorProcessingStrategyFactory", "org.mule.runtime.core.internal.processor.strategy.ReactorStreamProcessingStrategyFactory", "org.mule.runtime.core.internal.processor.strategy.ProactorStreamProcessingStrategyFactory", "org.mule.runtime.core.internal.processor.strategy.WorkQueueProcessingStrategyFactory", "org.mule.runtime.core.internal.processor.strategy.WorkQueueStreamProcessingStrategyFactory"})
    public String processingStrategyFactory;
    @Param(value={"1"})
    public int subscribers;
    @Param(value={"256"})
    public int bufferSize;
    @Param(value={"10000"})
    public int maxConcurrency;

    protected MuleContext createMuleContextWithServices() throws MuleException {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<8> builderList = new ArrayList<8>();
        builderList.add(new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                AbstractFlowBenchmark.this.schedulerService = new DefaultSchedulerService();
                AbstractFlowBenchmark.this.schedulerService.start();
                LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)AbstractFlowBenchmark.this.schedulerService.getName(), (Object)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{SchedulerService.class}, (InvocationHandler)new PassThroughInvocationHandler(AbstractFlowBenchmark.this.schedulerService)));
                WeaveDefaultExpressionLanguageFactoryService weaveExpressionExecutor = new WeaveDefaultExpressionLanguageFactoryService(null);
                LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)weaveExpressionExecutor.getName(), (Object)weaveExpressionExecutor);
            }
        });
        builderList.add(new DefaultsConfigurationBuilder());
        return muleContextFactory.createMuleContext(builderList.toArray(new ConfigurationBuilder[0]));
    }

    @Setup
    public void setup() throws Exception {
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        ProcessingStrategyFactory factory = (ProcessingStrategyFactory)Class.forName(this.processingStrategyFactory).newInstance();
        if (factory instanceof AbstractStreamProcessingStrategyFactory) {
            ((AbstractStreamProcessingStrategyFactory)factory).setBufferSize(this.bufferSize);
            ((AbstractStreamProcessingStrategyFactory)factory).setSubscriberCount(this.subscribers);
        }
        this.source = new TriggerableMessageSource();
        this.flow = Flow.builder((String)"flow", (MuleContext)this.muleContext).processors(this.getMessageProcessors()).source((MessageSource)this.source).processingStrategyFactory(factory).maxConcurrency(this.maxConcurrency).build();
        this.flow.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.from((String)"flow")));
        LegacyRegistryUtils.registerObject((MuleContext)this.muleContext, (String)"flow", (Object)this.flow, FlowConstruct.class);
    }

    protected abstract List<Processor> getMessageProcessors();

    protected abstract int getStreamIterations();

    @TearDown
    public void teardown() throws MuleException {
        this.muleContext.dispose();
        this.schedulerService.stop();
    }

    @Benchmark
    public CoreEvent processSourceBlocking() throws MuleException {
        return this.source.trigger(CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)AbstractBenchmark.CONNECTOR_LOCATION)).message(Message.of((Object)AbstractBenchmark.PAYLOAD)).build());
    }

    @Benchmark
    public CountDownLatch processSourceStream() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(this.getStreamIterations());
        for (int i = 0; i < this.getStreamIterations(); ++i) {
            Mono.just((Object)CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)AbstractBenchmark.CONNECTOR_LOCATION)).message(Message.of((Object)AbstractBenchmark.PAYLOAD)).build()).transform((Function)this.source.getListener()).doOnNext(event -> latch.countDown()).subscribe();
        }
        latch.await();
        return latch;
    }

    private static class PassThroughInvocationHandler
    implements InvocationHandler {
        private final Object target;

        public PassThroughInvocationHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.target, args);
        }
    }
}

