/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth;

import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.sdk.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

@AuthorizationCode(accessTokenUrl="accessTokenUrl", authorizationUrl="authUrl")
@Alias(value="refresh-validation")
public class TestOAuthRefreshValidationProvider
extends TestOAuthConnectionState
implements CachedConnectionProvider<TestOAuthConnection> {
    public static int TIMES_REFRESH_IS_NEEDED = 0;
    public static final String ACCESS_TOKEN_URL = "accessTokenUrl";
    public static final String AUTH_URL = "authUrl";
    public static final String DEFAULT_SCOPE = "defaultScope";

    public TestOAuthConnection connect() throws ConnectionException {
        return new TestOAuthConnection(this);
    }

    public void disconnect(TestOAuthConnection connection) {
    }

    public ConnectionValidationResult validate(TestOAuthConnection connection) {
        if (TIMES_REFRESH_IS_NEEDED > 0) {
            --TIMES_REFRESH_IS_NEEDED;
            return ConnectionValidationResult.failure((String)"The token needs to be refreshed", (Exception)new AccessTokenExpiredException());
        }
        return ConnectionValidationResult.success();
    }
}

