/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.spring.api.SpringConfig;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.IntegrationTestCaseRunnerConfig;

@Feature(value="Configuration component locator")
@Story(value="Search configuration")
public class LazyInitSecurityConfigurationComponentLocatorTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    @Rule
    public DynamicPort listenPort = new DynamicPort("http.listener.port");
    @Inject
    private Registry registry;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "org/mule/test/integration/locator/component-locator-spring-config.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Description(value="Lazy init should not create components until an operation is done")
    @Test
    public void lazyInitCalculatesLocations() {
        List allLocations = this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList());
        Assert.assertThat((String)allLocations.toString(), allLocations, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"springConfig", "null", "null/0", "securityManager2", "securityManager2/0", "listenerConfig", "listenerConfig/connection", "SecureUMO", "SecureUMO/source", "SecureUMO/processors/0", "SecureUMO/processors/1", "SecureUMO2", "SecureUMO2/source", "SecureUMO2/processors/0", "SecureUMO2/processors/0/0/0", "SecureUMO2/processors/1"}));
    }

    @Description(value="Lazy init should create spring components without dependencies")
    @Test
    public void lazyMuleContextInitializesSpringConfig() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("myFlow"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.registry.lookupByName("springConfig").isPresent(), (Matcher)Matchers.is((Object)true));
        SpringConfig springConfig = (SpringConfig)this.registry.lookupByName("springConfig").get();
        Object applicationContext = FieldUtils.readField((Object)springConfig, (String)"applicationContext", (boolean)true);
        Assert.assertThat((String)"springConfig was not configured", (Object)applicationContext, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)springConfig.getObject("child1").isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Description(value="Lazy init should create spring components without dependencies")
    @Test
    public void lazyMuleContextShouldNotFailWhenTryingToInitializeGlobalProperty() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("some.property"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"some.property").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Description(value="Lazy init should create spring security manager without dependencies")
    @Test
    public void lazyMuleContextInitializesSpringSecurityManager() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("SecureUMO"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig/connection").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO/processors/1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.registry.lookupByName("_muleSecurityManager").isPresent(), (Matcher)Matchers.is((Object)true));
        SecurityManager securityManager = (SecurityManager)this.registry.lookupByName("_muleSecurityManager").get();
        Assert.assertThat((String)"spring security provider was not registered", (Object)securityManager.getProvider("memory-dao"), (Matcher)Matchers.notNullValue());
    }

    @Description(value="Lazy init should create spring security manager without dependencies")
    @Test
    public void lazyMuleContextInitializesNamedSpringSecurityManager() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("SecureUMO2"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig/connection").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO2/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO2/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO2/processors/1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.registry.lookupByName("_muleSecurityManager").isPresent(), (Matcher)Matchers.is((Object)true));
        SecurityManager securityManager = (SecurityManager)this.registry.lookupByName("securityManager2").get();
        Assert.assertThat((String)"spring security provider was not registered", (Object)securityManager.getProvider("memory-dao2"), (Matcher)Matchers.notNullValue());
    }

    @Description(value="Spring component should be created each time as the rest")
    @Test
    public void lazyMuleContextSpringConfigRebuilt() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("SecureUMO"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Object firstObj = this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()).get();
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("SecureUMO2"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Object secondObj = this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()).get();
        Object secondAppContext = FieldUtils.readField(secondObj, (String)"applicationContext", (boolean)true);
        Assert.assertThat((String)"springConfig was not configured", (Object)secondAppContext, (Matcher)Matchers.notNullValue());
        Assert.assertThat(firstObj, (Matcher)Matchers.not((Matcher)Matchers.sameInstance(secondObj)));
    }
}

