/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.Iterator;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.test.IntegrationTestCaseRunnerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityNamespaceHandlerTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityNamespaceHandlerTestCase.class);

    protected String getConfigFile() {
        return "org/mule/test/config/security-namespace-config.xml";
    }

    @Test
    public void testSecurity() throws Exception {
        SecurityManager securityManager = muleContext.getSecurityManager();
        SecurityProvider dummySecurityProvider = securityManager.getProvider("dummySecurityProvider");
        Assert.assertNotNull((Object)dummySecurityProvider);
        Assert.assertThat((Object)dummySecurityProvider.getClass().getName(), (Matcher)Matchers.is((Object)"org.mule.runtime.config.internal.CustomSecurityProviderDelegate"));
        this.verifyEncryptionStrategy(securityManager, "dummyEncryptionStrategy", "org.mule.runtime.config.internal.CustomEncryptionStrategyDelegate");
        this.verifyEncryptionStrategy(securityManager, "passwordEncryptionStrategy", "org.mule.runtime.core.internal.security.PasswordBasedEncryptionStrategy");
        this.verifyEncryptionStrategy(securityManager, "secretKeyEncryptionStrategy", "org.mule.runtime.core.internal.security.SecretKeyEncryptionStrategy");
    }

    @Test
    public void testProvidersAreInitialized() throws Exception {
        SecurityManager securityManager = muleContext.getSecurityManager();
        SecurityProvider customDelegateSecurityProvider = securityManager.getProvider("initializableProvider");
        InitTrackerSecurityProvider initTrackerSecurityProvider = (InitTrackerSecurityProvider)FieldUtils.readField((Object)customDelegateSecurityProvider, (String)"delegate", (boolean)true);
        Assert.assertThat((Object)initTrackerSecurityProvider.isInitialised(), (Matcher)Matchers.is((Object)true));
    }

    private void verifyEncryptionStrategy(SecurityManager securityManager, String name, String className) {
        this.doVerifyEncriptionStrategy(securityManager, name);
        Assert.assertThat((Object)securityManager.getEncryptionStrategy(name).getClass().getName(), (Matcher)Matchers.is((Object)className));
    }

    public void doVerifyEncriptionStrategy(SecurityManager securityManager, String name) {
        Iterator strategies = securityManager.getEncryptionStrategies().iterator();
        LOGGER.debug("Listing strategies");
        while (strategies.hasNext()) {
            EncryptionStrategy strategy = (EncryptionStrategy)strategies.next();
            LOGGER.debug(strategy.getName() + " / " + strategy.toString() + " / " + strategy.getClass());
        }
        Assert.assertNotNull((String)name, (Object)securityManager.getEncryptionStrategy(name));
    }

    public static class InitTrackerSecurityProvider
    implements SecurityProvider,
    Initialisable {
        private boolean initialised = false;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Authentication authenticate(Authentication authentication) throws SecurityException {
            return null;
        }

        public boolean supports(Class<?> aClass) {
            return false;
        }

        public SecurityContext createSecurityContext(Authentication auth) throws UnknownAuthenticationTypeException {
            return null;
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public boolean isInitialised() {
            return this.initialised;
        }
    }
}

