/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.extension.reconnection;

import java.util.concurrent.TimeUnit;
import org.mule.extension.test.extension.reconnection.SynchronizableConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.extension.api.annotation.Alias;

@Alias(value="long-disconnection")
public class LongDisconnectionConnectionProvider
implements PoolingConnectionProvider<SynchronizableConnection> {
    private static final int DISCONNECTION_TIMEOUT = 3;

    public SynchronizableConnection connect() throws ConnectionException {
        return new SynchronizableConnection();
    }

    public void disconnect(SynchronizableConnection synchronizableConnection) {
        try {
            boolean result = synchronizableConnection.getDisconnectionLatch().await(3L, TimeUnit.SECONDS);
            synchronizableConnection.setDisconnectionWaitedFullTimeout(!result);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionValidationResult validate(SynchronizableConnection synchronizableConnection) {
        return ConnectionValidationResult.success();
    }
}

