/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class PetAdoptionPolling {
    private static final long DEFAULT_FREQUENCY = 1000L;
    private static final long DEFAULT_START_DELAY = 1000L;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    @Parameter
    @Summary(value="Configures the scheduler that triggers the polling")
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Scheduler schedulingStrategy;

    public Scheduler getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public void setSchedulingStrategy(Scheduler schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    public org.mule.runtime.api.scheduler.Scheduler createExecutor(String subscriberName, SchedulerService schedulerService) {
        this.initaliseStrategy();
        return schedulerService.customScheduler(SchedulerConfig.config().withName(subscriberName).withMaxConcurrentTasks(1).withWaitAllowed(false));
    }

    private void initaliseStrategy() {
        if (this.schedulingStrategy == null) {
            FixedFrequencyScheduler strategy = new FixedFrequencyScheduler();
            strategy.setTimeUnit(DEFAULT_TIME_UNIT);
            strategy.setFrequency(1000L);
            strategy.setStartDelay(1000L);
            this.schedulingStrategy = strategy;
        }
    }

    public Optional<Long> getFrequency() {
        return this.schedulingStrategy instanceof FixedFrequencyScheduler ? Optional.of(((FixedFrequencyScheduler)this.schedulingStrategy).getFrequency()) : Optional.empty();
    }
}

