/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.module.extension.oauth.authcode;

import static org.mule.runtime.api.connectivity.ConnectivityTestingService.CONNECTIVITY_TESTING_SERVICE_KEY;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static com.github.tomakehurst.wiremock.client.WireMock.postRequestedFor;
import static com.github.tomakehurst.wiremock.client.WireMock.urlPathEqualTo;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractAuthCodeExternalServerTestCase extends BaseOAuthExtensionTestCase {

  @Inject
  @Named(CONNECTIVITY_TESTING_SERVICE_KEY)
  protected ConnectivityTestingService connectivityTestingService;

  @Override
  public boolean addToolingObjectsToRegistry() {
    return true;
  }

  @Before
  public void setOwnerId() throws Exception {
    ownerId = getCustomOwnerId();
  }

  @Test
  public void expiredToken() throws Exception {
    ConnectionValidationResult connectionValidationResult = testConnection();
    assertThat(connectionValidationResult.isValid(), is(false));
  }

  @Test
  public void refreshTokenOnConnectionValidation() throws Exception {
    simulateCallback();

    wireMock.resetAll();
    stubRefreshToken();

    ConnectionValidationResult connectionValidationResult = testConnection();
    assertThat(connectionValidationResult.isValid(), is(true));
    wireMock.verify(postRequestedFor(urlPathEqualTo("/" + TOKEN_PATH)));
  }

  @Test
  public void refreshedTokenAlreadyExpiredOnConnectionValidation() throws Exception {
    simulateCallback();

    stubRefreshedTokenAlreadyExpiredOnce();

    ConnectionValidationResult connectionValidationResult = testConnection();
    verifyTokenRefreshedTwice();
    assertThat(connectionValidationResult.isValid(), is(true));
  }

  private ConnectionValidationResult testConnection() {
    return connectivityTestingService.testConnection(Location.builder().globalName("oauth").build());
  }

}
