/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.metadata.extension.resolver;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.test.metadata.extension.MetadataConnection;

public class TestMetadataResolverUtils {
    public static final String TIRES = "Tires";
    public static final String DIRECTION = "Direction";
    public static final String NAME = "Name";
    public static final String APPLICATION_JAVA_MIME_TYPE = "application/java";
    public static final String BRAND = "Brand";
    public static final String SIZE = "Size";
    public static final String AGE = "Age";

    public static Set<MetadataKey> getKeys(MetadataContext context) throws ConnectionException {
        return context.getConnection().map(c -> {
            MetadataConnection connection = (MetadataConnection)c;
            return connection.getEntities().stream().map(e -> MetadataKeyBuilder.newKey((String)e).build()).collect(Collectors.toSet());
        }).orElse(Collections.emptySet());
    }

    public static MetadataType getMetadata(String key) throws MetadataResolvingException {
        switch (key) {
            case "CAR": {
                return TestMetadataResolverUtils.getCarMetadata();
            }
            case "HOUSE": {
                return TestMetadataResolverUtils.getHouseMetadata();
            }
            case "PERSON": {
                return TestMetadataResolverUtils.getPersonMetadata();
            }
            case "NULL": {
                return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).nullType().build();
            }
            case "VOID": {
                return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build();
            }
        }
        throw new MetadataResolvingException("Unknown key " + key, FailureCode.INVALID_METADATA_KEY);
    }

    public static MetadataType getCarMetadata() {
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectBuilder.addField().key(TIRES).value().numberType();
        objectBuilder.addField().key(BRAND).value().stringType();
        return objectBuilder.build();
    }

    public static MetadataType getHouseMetadata() {
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectBuilder.addField().key(DIRECTION).value().stringType();
        objectBuilder.addField().key(SIZE).value().numberType();
        return objectBuilder.build();
    }

    public static MetadataType getPersonMetadata() {
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectBuilder.addField().key(NAME).value().stringType();
        objectBuilder.addField().key(AGE).value().numberType();
        return objectBuilder.build();
    }
}

