/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.drstrange;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.test.marvel.drstrange.DrStrange;

@Alias(value="bytes-caster")
public class DrStrangeBytesSource
extends Source<InputStream, Void> {
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    @Parameter
    private long castFrequencyInMillis;
    @Parameter
    private String spell;
    @Parameter
    @Optional(defaultValue="1")
    private int spellSize;
    @Config
    private DrStrange config;

    public void onStart(SourceCallback<InputStream, Void> sourceCallback) throws MuleException {
        this.scheduler = this.schedulerService.cpuLightScheduler();
        this.scheduler.scheduleAtFixedRate(() -> sourceCallback.handle(Result.builder().output((Object)new ByteArrayInputStream(this.getSpellBytes(this.spell))).build()), 0L, this.castFrequencyInMillis, TimeUnit.MILLISECONDS);
    }

    private byte[] getSpellBytes(String spell) {
        while (spell.length() < this.spellSize) {
            spell = spell + spell;
        }
        return spell.getBytes();
    }

    public void onStop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

