/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.notification.Fires;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.deprecated.Deprecated;
import org.mule.sdk.api.annotation.error.Throws;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.Example;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.client.DefaultOperationParametersBuilder;
import org.mule.sdk.api.client.OperationParameters;
import org.mule.sdk.api.future.SecretSdkFutureFeature;
import org.mule.sdk.api.meta.ExpressionSupport;
import org.mule.sdk.api.notification.NotificationActionDefinition;
import org.mule.sdk.api.notification.NotificationEmitter;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.sdk.api.runtime.parameter.ParameterResolver;
import org.mule.sdk.api.runtime.streaming.StreamingHelper;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergErrorTypeProvider;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergNotificationAction;
import org.mule.test.heisenberg.extension.HeisenbergOutputResolver;
import org.mule.test.heisenberg.extension.InputStreamParameterGroup;
import org.mule.test.heisenberg.extension.KnockNotificationProvider;
import org.mule.test.heisenberg.extension.TucoMetadataResolver;
import org.mule.test.heisenberg.extension.exception.CureCancerExceptionEnricher;
import org.mule.test.heisenberg.extension.exception.HealthException;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.exception.NullExceptionEnricher;
import org.mule.test.heisenberg.extension.model.BarberPreferences;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.KillParameters;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.MyInterface;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.RecursiveChainA;
import org.mule.test.heisenberg.extension.model.RecursiveChainB;
import org.mule.test.heisenberg.extension.model.RecursivePojo;
import org.mule.test.heisenberg.extension.model.SaleInfo;
import org.mule.test.heisenberg.extension.model.SimpleKnockeableDoor;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.drugs.DrugBatch;
import org.mule.test.heisenberg.extension.model.types.IntegerAttributes;
import org.mule.test.heisenberg.extension.stereotypes.EmpireStereotype;
import org.mule.test.heisenberg.extension.stereotypes.KillingStereotype;

@Stereotype(value=EmpireStereotype.class)
public class HeisenbergOperations
implements Disposable {
    public static SecretSdkFutureFeature secretSdkFutureFeature = null;
    public static final String CURE_CANCER_MESSAGE = "Can't help you, you are going to die";
    public static final String CALL_GUS_MESSAGE = "You are not allowed to speak with gus.";
    public static final String KILL_WITH_GROUP = "KillGroup";
    public static final String OPERATION_WITH_DISPLAY_NAME_PARAMETER = "resolverEcho";
    public static final String OPERATION_WITH_SUMMARY = "knockMany";
    public static final String OPERATION_WITH_EXAMPLE = "alias";
    public static final String OPERATION_PARAMETER_ORIGINAL_OVERRIDED_DISPLAY_NAME = "literalExpression";
    public static final String OPERATION_PARAMETER_OVERRIDED_DISPLAY_NAME = "Custom overrided display name";
    public static final String KNOCKEABLE_DOORS_SUMMARY = "List of Knockeable Doors";
    public static final String DOOR_PARAMETER = "doors";
    public static final String GREETING_PARAMETER = "greeting";
    public static final String OPERATION_PARAMETER_EXAMPLE = "Hello my friend!";
    public static volatile boolean disposed = false;
    public static Integer streamRead = -1;
    @Inject
    private ExtensionManager extensionManager;
    private final LazyValue<ExecutorService> executor = new LazyValue(() -> Executors.newSingleThreadExecutor());

    @MediaType(value="*/*")
    public String usingInterface(@Content MyInterface myInterface) {
        return null;
    }

    @MediaType(value="*/*")
    public String usingInterfaceB(@Content MyInterface myInterface) {
        return null;
    }

    @MediaType(value="*/*")
    public String usingInterfaceC(@Content MyInterface myInterface) {
        return null;
    }

    public List<Result<String, Object>> getSimpleBlocklist(@Config HeisenbergExtension config) {
        LinkedList<Result<String, Object>> blocklist = new LinkedList<Result<String, Object>>();
        blocklist.add(Result.builder().output((Object)"Fring").build());
        blocklist.add(Result.builder().output((Object)"Salamanca").build());
        blocklist.add(Result.builder().output((Object)"Ehrmantraut").build());
        return blocklist;
    }

    public List<Result<InputStream, Object>> getBlocklist(@Config HeisenbergExtension config) {
        LinkedList<Result<InputStream, Object>> blocklist = new LinkedList<Result<InputStream, Object>>();
        blocklist.add(Result.builder().output((Object)new ByteArrayInputStream("Fring".getBytes())).build());
        blocklist.add(Result.builder().output((Object)new ByteArrayInputStream("Salamanca".getBytes())).build());
        blocklist.add(Result.builder().output((Object)new ByteArrayInputStream("Ehrmantraut".getBytes())).build());
        return blocklist;
    }

    public PagingProvider<HeisenbergConnection, Result<InputStream, Object>> getPagedBlocklist(@Config HeisenbergExtension config) {
        return new PagingProvider<HeisenbergConnection, Result<InputStream, Object>>(){
            private static final int LIST_PAGE_SIZE = 2;
            private List<Result<InputStream, Object>> blocklist;
            private Iterator<Result<InputStream, Object>> blocklistIterator;

            public void initializeList() {
                this.blocklist = new LinkedList<Result<InputStream, Object>>();
                this.blocklist.add((Result<InputStream, Object>)Result.builder().output((Object)new ByteArrayInputStream("Fring".getBytes())).build());
                this.blocklist.add((Result<InputStream, Object>)Result.builder().output((Object)new ByteArrayInputStream("Salamanca".getBytes())).build());
                this.blocklist.add((Result<InputStream, Object>)Result.builder().output((Object)new ByteArrayInputStream("Ehrmantraut".getBytes())).build());
                this.blocklist.add((Result<InputStream, Object>)Result.builder().output((Object)new ByteArrayInputStream("Alquist".getBytes())).build());
                this.blocklist.add((Result<InputStream, Object>)Result.builder().output((Object)new ByteArrayInputStream("Schrader".getBytes())).build());
                this.blocklist.add((Result<InputStream, Object>)Result.builder().output((Object)new ByteArrayInputStream("Gomez".getBytes())).build());
                this.blocklistIterator = this.blocklist.iterator();
            }

            public List<Result<InputStream, Object>> getPage(HeisenbergConnection connection) {
                if (this.blocklist == null) {
                    this.initializeList();
                }
                LinkedList<Result<InputStream, Object>> page = new LinkedList<Result<InputStream, Object>>();
                for (int i = 0; i < 2 && this.blocklistIterator.hasNext(); ++i) {
                    page.add(this.blocklistIterator.next());
                }
                return page;
            }

            public java.util.Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                if (this.blocklist == null) {
                    this.initializeList();
                }
                return java.util.Optional.of(this.blocklist.size());
            }

            public void close(HeisenbergConnection connection) throws MuleException {
                connection.disconnect();
            }
        };
    }

    public PagingProvider<HeisenbergConnection, Result<CursorProvider, Object>> getPagedCursorProviderBlocklist(@Config HeisenbergExtension config, final StreamingHelper streamingHelper) {
        return new PagingProvider<HeisenbergConnection, Result<CursorProvider, Object>>(){
            private static final int LIST_PAGE_SIZE = 2;
            private List<Result<CursorProvider, Object>> blocklist;
            private Iterator<Result<CursorProvider, Object>> blocklistIterator;

            public void initializeList() {
                this.blocklist = new LinkedList<Result<CursorProvider, Object>>();
                this.blocklist.add(this.asCursorProviderResult("Fring"));
                this.blocklist.add(this.asCursorProviderResult("Salamanca"));
                this.blocklist.add(this.asCursorProviderResult("Ehrmantraut"));
                this.blocklist.add(this.asCursorProviderResult("Alquist"));
                this.blocklist.add(this.asCursorProviderResult("Schrader"));
                this.blocklist.add(this.asCursorProviderResult("Gomez"));
                this.blocklistIterator = this.blocklist.iterator();
            }

            private Result<CursorProvider, Object> asCursorProviderResult(String name) {
                return Result.builder().output((Object)((CursorProvider)streamingHelper.resolveCursorProvider((Object)new ByteArrayInputStream(name.getBytes())))).build();
            }

            public List<Result<CursorProvider, Object>> getPage(HeisenbergConnection connection) {
                if (this.blocklist == null) {
                    this.initializeList();
                }
                LinkedList<Result<CursorProvider, Object>> page = new LinkedList<Result<CursorProvider, Object>>();
                for (int i = 0; i < 2 && this.blocklistIterator.hasNext(); ++i) {
                    page.add(this.blocklistIterator.next());
                }
                return page;
            }

            public java.util.Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                if (this.blocklist == null) {
                    this.initializeList();
                }
                return java.util.Optional.of(this.blocklist.size());
            }

            public void close(HeisenbergConnection connection) throws MuleException {
                connection.disconnect();
            }
        };
    }

    @OutputResolver(output=TucoMetadataResolver.class)
    @MediaType(strict=false, value="text/plain")
    public String colorizeMeth() {
        return "Blue";
    }

    @OutputResolver(output=TucoMetadataResolver.class)
    @MediaType(strict=false, value="text/plain")
    public String callDea() {
        return "Help DEA!";
    }

    @Streaming
    @MediaType(value="*/*", strict=false)
    public String sayMyName(@Config HeisenbergExtension config) {
        return config.getPersonalInfo().getName();
    }

    public void die(@org.mule.sdk.api.annotation.param.Config HeisenbergExtension config) {
        config.setEndingHealth(HealthStatus.DEAD);
    }

    @MediaType(value="text/plain")
    public Result<String, IntegerAttributes> getEnemy(@Config HeisenbergExtension config, @Optional(defaultValue="-1") @org.mule.sdk.api.annotation.param.Optional(defaultValue="0") int index) {
        Charset lastSupportedEncoding = Charset.availableCharsets().values().stream().reduce((first, last) -> last).get();
        DataType dt = DataType.builder().type(String.class).mediaType("dead/dead").charset(lastSupportedEncoding.toString()).build();
        return Result.builder().output((Object)config.getEnemies().get(index)).mediaType(dt.getMediaType()).attributes((Object)new IntegerAttributes(index)).build();
    }

    @MediaType(value="text/plain")
    public Result<String, IntegerAttributes> getEnemyLong(@Config HeisenbergExtension config, @Optional(defaultValue="0") long index) {
        return this.getEnemy(config, (int)index);
    }

    public List<Result<String, IntegerAttributes>> getAllEnemies(@Config HeisenbergExtension config) {
        ArrayList<Result<String, IntegerAttributes>> enemies = new ArrayList<Result<String, IntegerAttributes>>(config.getEnemies().size());
        for (int i = 0; i < config.getEnemies().size(); ++i) {
            enemies.add((Result<String, IntegerAttributes>)Result.builder().output((Object)config.getEnemies().get(i)).attributes((Object)new IntegerAttributes(i)).build());
        }
        return enemies;
    }

    @MediaType(value="text/plain")
    public String echoStaticMessage(@Expression(value=ExpressionSupport.NOT_SUPPORTED) String message) {
        return message;
    }

    @MediaType(value="text/plain")
    public String echoWithSignature(@Optional String message) {
        return (message == null ? "" : message) + " echoed by Heisenberg";
    }

    @MediaType(value="text/plain")
    public String executeForeingOrders(String extensionName, String operationName, @Optional String configName, ExtensionsClient extensionsClient, Map<String, Object> operationParameters) throws MuleException {
        Object output = extensionsClient.execute(extensionName, operationName, this.createOperationParameters(configName, operationParameters)).getOutput();
        return output instanceof TypedValue ? (String)((TypedValue)output).getValue() : (String)output;
    }

    @MediaType(value="text/plain")
    public String executeWithMapParam(LinkedHashMap<String, Object> mapParameters) throws MuleException {
        return mapParameters.toString();
    }

    @MediaType(value="text/plain")
    public String sdkExecuteForeingOrders(String extensionName, String operationName, @Optional String configName, org.mule.sdk.api.client.ExtensionsClient extensionsClient, Map<String, Object> operationParameters) throws MuleException {
        Object output = extensionsClient.execute(extensionName, operationName, this.createSdkOperationParameters(configName, operationParameters)).getOutput();
        return output instanceof TypedValue ? (String)((TypedValue)output).getValue() : (String)output;
    }

    private org.mule.runtime.extension.api.client.OperationParameters createOperationParameters(String configName, Map<String, Object> operationParameters) {
        org.mule.runtime.extension.api.client.DefaultOperationParametersBuilder builder = DefaultOperationParameters.builder();
        if (configName != null) {
            builder.configName(configName);
        }
        operationParameters.forEach((key, value) -> builder.addParameter(key, value));
        return builder.build();
    }

    private OperationParameters createSdkOperationParameters(String configName, Map<String, Object> operationParameters) {
        DefaultOperationParametersBuilder builder = org.mule.sdk.api.client.DefaultOperationParameters.builder();
        if (configName != null) {
            builder.configName(configName);
        }
        operationParameters.forEach((key, value) -> builder.addParameter(key, value));
        return builder.build();
    }

    @MediaType(value="*/*")
    public void tapPhones(Chain operations, CompletionCallback<Object, Object> callback) {
        System.out.println("Started tapping phone");
        operations.process(result -> {
            System.out.println("Finished tapping phone successfully");
            callback.success(result);
        }, (error, previous) -> {
            System.out.println("Finished tapping phone with error with message: " + error.getMessage());
            callback.error(error);
        });
    }

    @Deprecated(message="The usage of this operation must be replaced by the knock operation.", since="1.5.0", toRemoveIn="2.0.0")
    @Stereotype(value=KillingStereotype.class)
    @MediaType(value="text/plain")
    public String kill(@Optional(defaultValue="#[payload]") String victim, @Deprecated(message="There is now a standarized way to say goodbye to your enemies before knocking them up, using a different message will only be supported until the next mayor release", since="1.4.0") @Optional(defaultValue="We are done") String goodbyeMessage) throws Exception {
        KillParameters killParameters = new KillParameters(victim, goodbyeMessage);
        return String.format("%s, %s", killParameters.getGoodbyeMessage(), killParameters.getVictim());
    }

    @MediaType(value="text/plain")
    @Fires(value={KnockNotificationProvider.class})
    public String knock(KnockeableDoor knockedDoor, NotificationEmitter notificationEmitter) {
        TypedValue door = TypedValue.of((Object)new SimpleKnockeableDoor(knockedDoor));
        notificationEmitter.fire((NotificationActionDefinition)HeisenbergNotificationAction.KNOCKING_DOOR, door);
        String knock = knockedDoor.knock();
        notificationEmitter.fire((NotificationActionDefinition)HeisenbergNotificationAction.KNOCKED_DOOR, door);
        return knock;
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public ExtensionManager getInjectedExtensionManager() {
        return this.extensionManager;
    }

    @MediaType(value="text/plain")
    public String alias(@Example(value="Hello my friend!") String greeting, @ParameterGroup(name="Personal Info") PersonalInfo info) {
        return String.format("%s, my name is %s and I'm %d years old", greeting, info.getName(), info.getAge());
    }

    public BarberPreferences getBarberPreferences(@Config HeisenbergExtension config) {
        return config.getBarberPreferences();
    }

    public BarberPreferences getSecondBarberPreferences(@Config HeisenbergExtension config) {
        return config.getSecondBarberPreferences();
    }

    public BarberPreferences getInlineInfo(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Personal Barber", showInDsl=true) @org.mule.sdk.api.annotation.param.display.DisplayName(value="Personal preference") BarberPreferences preferences) {
        return preferences;
    }

    public PersonalInfo getInlinePersonalInfo(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Personal Info Argument", showInDsl=true) @DisplayName(value="Personal preference") PersonalInfo info) {
        return info;
    }

    @MediaType(value="text/plain")
    public String transform(String transformation) {
        return transformation;
    }

    public void disguice(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="currentLook") @org.mule.sdk.api.annotation.param.display.DisplayName(value="Look") BarberPreferences currentLook, @ParameterGroup(name="disguise", showInDsl=true) @org.mule.sdk.api.annotation.param.display.DisplayName(value="Look") BarberPreferences disguise) {
    }

    public List<String> knockMany(@Summary(value="List of Knockeable Doors") List<KnockeableDoor> doors) {
        return doors.stream().map(KnockeableDoor::knock).collect(Collectors.toList());
    }

    @MediaType(value="text/plain")
    public String callSaul(@Connection HeisenbergConnection connection) {
        return connection.callSaul();
    }

    @MediaType(value="text/plain")
    public String callGusFring() throws HeisenbergException {
        throw new HeisenbergException(CALL_GUS_MESSAGE);
    }

    @MediaType(value="text/plain")
    public void callGusFringNonBlocking(org.mule.sdk.api.runtime.process.CompletionCallback<Void, Void> callback) {
        ((ExecutorService)this.executor.get()).execute(() -> callback.error((Throwable)new HeisenbergException(CALL_GUS_MESSAGE)));
    }

    @OnException(value=CureCancerExceptionEnricher.class)
    @Throws(value={HeisenbergErrorTypeProvider.class})
    @MediaType(value="text/plain")
    public String cureCancer() throws HealthException {
        throw new HealthException(CURE_CANCER_MESSAGE);
    }

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public Investment approve(Investment investment, @Optional RecursivePojo recursivePojo, @Optional RecursiveChainB recursiveChainB, @Optional RecursiveChainA recursiveChainA) {
        investment.approve();
        return investment;
    }

    public Map<String, HealthStatus> getMedicalHistory(Map<String, HealthStatus> healthByYear) {
        return healthByYear;
    }

    public HeisenbergConnection getConnection(@Connection HeisenbergConnection connection) {
        return connection;
    }

    @MediaType(value="text/plain")
    public String getSaulPhone(@Connection HeisenbergConnection connection) {
        return connection.getSaulPhoneNumber();
    }

    @MediaType(value="text/plain")
    public org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<String> resolverEcho(@DisplayName(value="Custom overrided display name") org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<String> literalExpression) {
        return literalExpression;
    }

    @MediaType(value="text/plain")
    public String literalEcho(Literal<String> literalExpression) {
        return literalExpression.getLiteralValue().orElse(null);
    }

    public int[][] getGramsInStorage(@Optional(defaultValue="#[payload]") int[][] grams) {
        return grams;
    }

    public Map<String, SaleInfo> processSale(Map<String, SaleInfo> sales) {
        return sales;
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public ParameterResolver<Weapon> processWeapon(@Optional ParameterResolver<Weapon> weapon) {
        return weapon;
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public ParameterResolver<List<Weapon>> processWeaponList(@Optional ParameterResolver<List<Weapon>> weapons) {
        return weapons;
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<Weapon> processWeaponWithDefaultValue(@Optional(defaultValue="#[payload]") org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<Weapon> weapon) {
        return weapon;
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<List<Weapon>> processWeaponListWithDefaultValue(@Optional(defaultValue="#[payload]") org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<List<Weapon>> weapons) {
        return weapons;
    }

    public org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<List<String>> processAddressBook(org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<List<String>> phoneNumbers) {
        return phoneNumbers;
    }

    @org.mule.sdk.api.annotation.OnException(value=NullExceptionEnricher.class)
    public void failToExecute() throws HeisenbergException {
        this.callGusFring();
    }

    public void storeMoney(ObjectStore<Long> objectStore, Long money) throws Exception {
        objectStore.store("money", (Serializable)money);
    }

    @Ignore
    public void ignoredOperation() {
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public Map<String, Weapon> byPassWeapon(@Alias(value="awesomeWeapon") Weapon weapon, @org.mule.runtime.extension.api.annotation.Alias(value="awesomeName") String name) {
        return ImmutableMap.of((Object)name, (Object)weapon);
    }

    @Alias(value="echo")
    @MediaType(value="text/plain")
    public org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<String> resolverEchoWithAlias(@DisplayName(value="Custom overrided display name") org.mule.runtime.extension.api.runtime.parameter.ParameterResolver<String> literalExpression) {
        return literalExpression;
    }

    @MediaType(value="text/plain")
    public String operationWithInputStreamContentParam(@org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="Test", showInDsl=true) InputStreamParameterGroup isGroup) {
        return IOUtils.toString((InputStream)isGroup.getInputStreamContent());
    }

    public void throwError() {
        throw new LinkageError();
    }

    @MediaType(value="text/plain", strict=false)
    public InputStream nameAsStream(@Config HeisenbergExtension config) {
        return new ByteArrayInputStream(this.sayMyName(config).getBytes());
    }

    public void dispose() {
        this.executor.ifComputed(ExecutorService::shutdown);
        disposed = true;
    }

    @MediaType(value="text/plain")
    public String executeKillWithClient(String configName, ExtensionsClient client) {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(configName).addParameter("victim", (Object)"Juani").addParameter("goodbyeMessage", (Object)"ADIOS").build();
        try {
            return (String)client.execute("Heisenberg", "kill", (org.mule.runtime.extension.api.client.OperationParameters)params).getOutput();
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    @MediaType(value="text/plain")
    public String executeRemoteKill(String extension, String configName, String operation, @Content Map<String, String> parameters, ExtensionsClient client) {
        org.mule.runtime.extension.api.client.DefaultOperationParametersBuilder paramsBuilder = DefaultOperationParameters.builder().configName(configName);
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            paramsBuilder = paramsBuilder.addParameter(param.getKey(), (Object)param.getValue());
        }
        try {
            client.execute(extension, operation, (org.mule.runtime.extension.api.client.OperationParameters)paramsBuilder.build()).getOutput();
            return "Now he sleeps with the fishes.";
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    public void blockingNonBlocking(CompletionCallback<Void, Void> completionCallback) {
    }

    @OutputResolver(output=HeisenbergOutputResolver.class)
    public Map<String, Object> getInjectedObjects(@Optional Object object, @Optional Serializable serializable) {
        return ImmutableMap.builder().put((Object)"object", object).put((Object)"serializable", (Object)serializable).build();
    }

    public PagingProvider<HeisenbergConnection, Result<DrugBatch, String>> getDrugs() {
        return new PagingProvider<HeisenbergConnection, Result<DrugBatch, String>>(){

            public List<Result<DrugBatch, String>> getPage(HeisenbergConnection connection) {
                return new ArrayList<Result<DrugBatch, String>>();
            }

            public java.util.Optional<Integer> getTotalResults(HeisenbergConnection connection) {
                return java.util.Optional.empty();
            }

            public void close(HeisenbergConnection connection) throws MuleException {
            }
        };
    }

    @MediaType(value="text/plain", strict=false)
    public InputStream nameAsStreamConnected(final @Config HeisenbergExtension config, @Connection HeisenbergConnection connection, final Integer failOn) throws ConnectionException {
        Integer n = streamRead;
        Integer n2 = streamRead = Integer.valueOf(streamRead + 1);
        if (streamRead.equals(failOn)) {
            throw new ConnectionException("Failed to return the InputStream");
        }
        return new InputStream(){
            private int bytesRead = 0;
            private final byte[] name = config.getPersonalInfo().getName().getBytes();

            @Override
            public int read() {
                Integer n = streamRead;
                Integer n2 = streamRead = Integer.valueOf(streamRead + 1);
                if (streamRead.equals(failOn)) {
                    throw new RuntimeException("Failed to read the stream");
                }
                if (this.bytesRead < this.name.length) {
                    ++this.bytesRead;
                    return this.name[this.bytesRead - 1];
                }
                return -1;
            }
        };
    }

    public void futureSdkImplicitHandling(SecretSdkFutureFeature secretSdkFutureFeature) {
        HeisenbergOperations.secretSdkFutureFeature = secretSdkFutureFeature;
    }
}

