/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.heisenberg.extension;

import static org.mule.test.heisenberg.extension.HeisenbergNotificationAction.BATCH_DELIVERED;
import static org.mule.test.heisenberg.extension.HeisenbergNotificationAction.BATCH_DELIVERY_FAILED;
import static org.mule.test.heisenberg.extension.HeisenbergNotificationAction.BATCH_FAILED;
import static org.mule.test.heisenberg.extension.HeisenbergNotificationAction.BATCH_TERMINATED;
import static org.mule.test.heisenberg.extension.HeisenbergNotificationAction.NEW_BATCH;
import static org.mule.test.heisenberg.extension.HeisenbergNotificationAction.NEXT_BATCH;

import org.mule.sdk.api.annotation.notification.NotificationActionProvider;

import java.util.EnumSet;
import java.util.Set;

public class SourceNotificationProvider implements NotificationActionProvider {

  @Override
  public Set<HeisenbergNotificationAction> getNotificationActions() {
    return EnumSet.<HeisenbergNotificationAction>of(NEW_BATCH,
                                                    NEXT_BATCH,
                                                    BATCH_DELIVERED,
                                                    BATCH_DELIVERY_FAILED,
                                                    BATCH_FAILED,
                                                    BATCH_TERMINATED);
  }

}
