/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import jakarta.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.deprecated.Deprecated;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.sdk.api.annotation.notification.Fires;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.RicinGroup;
import org.mule.test.heisenberg.extension.SourceNotificationProvider;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfoAllOptional;

@Alias(value="ListenPaymentsAllOptional")
@EmitsResponse
@Fires(value={SourceNotificationProvider.class})
@Streaming
@MediaType(value="text/plain")
@BackPressure(defaultMode=BackPressureMode.FAIL, supportedModes={BackPressureMode.FAIL, BackPressureMode.DROP})
@Deprecated(message="This source is being tapped by the DEA, it's usage is discouraged.", since="1.6.0", toRemoveIn="3.0.0")
public class HeisenbergSourceAllOptionalCallbacks
extends Source<String, Object> {
    public static volatile boolean receivedGroupOnSource;
    public static volatile boolean receivedInlineOnSuccess;
    public static volatile boolean receivedInlineOnError;
    public static volatile PersonalInfoAllOptional receivedInlineOnSuccessData;
    public static volatile PersonalInfoAllOptional receivedInlineOnErrorData;
    public static volatile TerminateStatus terminateStatus;
    public static java.util.Optional<Error> error;
    public static volatile boolean executedOnSuccess;
    public static volatile boolean executedOnError;
    public static volatile boolean executedOnTerminate;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    private ScheduledFuture<?> scheduledFuture;
    @Config
    private HeisenbergExtension heisenberg;
    @Connection
    private ConnectionProvider<HeisenbergConnection> connectionProvider;
    private HeisenbergConnection connection;

    public HeisenbergSourceAllOptionalCallbacks() {
        HeisenbergSourceAllOptionalCallbacks.resetHeisenbergSource();
    }

    public synchronized void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        Preconditions.checkArgument((this.heisenberg != null ? 1 : 0) != 0, (String)"config not injected");
        ++HeisenbergExtension.sourceTimesStarted;
        this.executor = this.schedulerService.cpuLightScheduler();
        this.connection = (HeisenbergConnection)this.connectionProvider.connect();
        this.scheduledFuture = this.executor.scheduleAtFixedRate(() -> {
            Result<String, Object> result = this.makeResult(sourceCallback);
            if (result != null) {
                SourceCallbackContext context = sourceCallback.createContext();
                sourceCallback.handle(result, context);
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    @OnSuccess
    public synchronized void onSuccess(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Long payment, @Optional String sameNameParameter, @ParameterGroup(name="Dangerous-Ricin") @DisplayName(value="Dangerous Ricin") RicinGroup ricin, @ParameterGroup(name="Success Info", showInDsl=true) PersonalInfoAllOptional successInfo, @org.mule.runtime.extension.api.annotation.param.Optional boolean fail) {
        receivedGroupOnSource = ricin != null && ricin.getNextDoor().getAddress() != null;
        receivedInlineOnSuccess = successInfo != null && successInfo.getAge() != null && successInfo.getKnownAddresses() != null;
        receivedInlineOnSuccessData = successInfo;
        executedOnSuccess = true;
        if (fail) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnError
    public synchronized void onError(Error error, @org.mule.runtime.extension.api.annotation.param.Optional String sameNameParameter, @org.mule.runtime.extension.api.annotation.param.Optional Methylamine methylamine, @ParameterGroup(name="Dangerous-Ricin") RicinGroup ricin, @ParameterGroup(name="Error Info", showInDsl=true) PersonalInfoAllOptional infoError, @Optional boolean propagateError) {
        receivedGroupOnSource = ricin != null && ricin.getNextDoor() != null && ricin.getNextDoor().getAddress() != null;
        receivedInlineOnError = infoError != null && infoError.getAge() != null && infoError.getKnownAddresses() != null;
        receivedInlineOnErrorData = infoError;
        executedOnError = true;
        if (propagateError) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnTerminate
    public synchronized void onTerminate(SourceResult sourceResult) {
        if (sourceResult.isSuccess()) {
            terminateStatus = TerminateStatus.SUCCESS;
            error = java.util.Optional.empty();
        } else {
            sourceResult.getInvocationError().ifPresent(parameterError -> {
                terminateStatus = TerminateStatus.ERROR_INVOKE;
                error = java.util.Optional.of(parameterError);
            });
            sourceResult.getResponseError().ifPresent(bodyError -> {
                terminateStatus = TerminateStatus.ERROR_BODY;
                error = java.util.Optional.of(bodyError);
            });
        }
        executedOnTerminate = true;
    }

    @OnBackPressure
    public void onBackPressure(BackPressureContext ctx) {
        this.heisenberg.onBackPressure(ctx);
    }

    public synchronized void onStop() {
        receivedInlineOnSuccessData = null;
        receivedInlineOnErrorData = null;
        if (this.executor != null && this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.executor.stop();
        }
        if (this.connection != null && this.connectionProvider != null) {
            this.connectionProvider.disconnect((Object)this.connection);
        }
        receivedGroupOnSource = false;
    }

    private Result<String, Object> makeResult(SourceCallback sourceCallback) {
        return Result.builder().output((Object)String.format("Meth Batch. If found by DEA contact %s", this.connection.getSaulPhoneNumber())).build();
    }

    public static synchronized void resetHeisenbergSource() {
        receivedGroupOnSource = false;
        receivedInlineOnSuccess = false;
        receivedInlineOnError = false;
        terminateStatus = TerminateStatus.NONE;
        error = null;
        executedOnSuccess = false;
        executedOnError = false;
        executedOnTerminate = false;
        receivedInlineOnSuccessData = null;
        receivedInlineOnErrorData = null;
    }

    public static enum TerminateStatus {
        SUCCESS,
        ERROR_INVOKE,
        ERROR_BODY,
        NONE;

    }
}

