/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.heisenberg.extension.exception;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.sdk.api.runtime.exception.ExceptionHandler;

public class SdkHeisenbergConnectionExceptionEnricher extends ExceptionHandler {

  public static final String ENRICHED_MESSAGE = "Enriched Connection Exception: ";

  @Override
  public Exception enrichException(Exception e) {
    if (e instanceof MuleFatalException) {
      return e;
    }
    return new ConnectionException(ENRICHED_MESSAGE + e.getMessage(), e);
  }
}
