/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.deprecated.Deprecated;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.sdk.api.annotation.notification.Fires;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.source.BackPressure;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.runtime.source.BackPressureContext;
import org.mule.sdk.api.runtime.source.BackPressureMode;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergNotificationAction;
import org.mule.test.heisenberg.extension.RicinGroup;
import org.mule.test.heisenberg.extension.SdkSourceNotificationProvider;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Weapon;

@Alias(value="ListenPayments")
@EmitsResponse
@Fires(value={SdkSourceNotificationProvider.class})
@Streaming
@MediaType(value="text/plain")
@BackPressure(defaultMode=BackPressureMode.FAIL, supportedModes={BackPressureMode.FAIL, BackPressureMode.DROP})
@Deprecated(message="This source is being tapped by the DEA, it's usage is discouraged.", since="1.6.0", toRemoveIn="3.0.0")
public class HeisenbergSource
extends Source<String, Object> {
    public static final String CORE_POOL_SIZE_ERROR_MESSAGE = "corePoolSize cannot be a negative value";
    public static final String INITIAL_BATCH_NUMBER_ERROR_MESSAGE = "initialBatchNumber cannot be a negative value";
    private static final String BATCH_NUMBER = "batchNumber";
    public static volatile boolean receivedGroupOnSource;
    public static volatile boolean receivedInlineOnSuccess;
    public static volatile boolean receivedInlineOnError;
    public static volatile TerminateStatus terminateStatus;
    public static java.util.Optional<Error> error;
    public static volatile boolean executedOnSuccess;
    public static volatile boolean executedOnError;
    public static volatile boolean executedOnTerminate;
    public static long gatheredMoney;
    public static String configName;
    public static String location;
    public static volatile Map<String, Object> receivedDebtProperties;
    public static volatile Map<String, Weapon> receivedUsableWeapons;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    private ScheduledFuture<?> scheduledFuture;
    @Config
    private HeisenbergExtension heisenberg;
    @Connection
    private ConnectionProvider<HeisenbergConnection> connectionProvider;
    @org.mule.runtime.extension.api.annotation.param.Parameter
    private volatile int initialBatchNumber;
    @org.mule.runtime.extension.api.annotation.param.Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="1")
    private int corePoolSize;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="500")
    private long frequency;
    @RefName
    private String refName;
    @org.mule.runtime.extension.api.annotation.param.Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    private Map<String, Object> debtProperties;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    private Map<String, Weapon> usableWeapons;
    private ComponentLocation componentLocation;
    private HeisenbergConnection connection;

    public HeisenbergSource() {
        HeisenbergSource.resetHeisenbergSource();
    }

    public synchronized void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        Preconditions.checkArgument((this.heisenberg != null ? 1 : 0) != 0, (String)"config not injected");
        ++HeisenbergExtension.sourceTimesStarted;
        configName = this.refName;
        location = this.componentLocation.getLocation();
        if (this.corePoolSize < 0) {
            throw new RuntimeException(CORE_POOL_SIZE_ERROR_MESSAGE);
        }
        receivedDebtProperties = this.debtProperties;
        receivedUsableWeapons = this.usableWeapons;
        this.executor = this.schedulerService.cpuLightScheduler();
        this.connection = (HeisenbergConnection)this.connectionProvider.connect();
        this.scheduledFuture = this.executor.scheduleAtFixedRate(() -> {
            Result<String, Object> result = this.makeResult(sourceCallback);
            if (result != null) {
                SourceCallbackContext context = sourceCallback.createContext();
                context.addVariable(BATCH_NUMBER, (Object)this.initialBatchNumber);
                context.fireOnHandle((NotificationActionDefinition)HeisenbergNotificationAction.NEW_BATCH, TypedValue.of((Object)this.initialBatchNumber));
                context.fireOnHandle((NotificationActionDefinition)HeisenbergNotificationAction.NEXT_BATCH, TypedValue.of((Object)this.frequency));
                sourceCallback.handle(result, context);
            }
        }, 0L, this.frequency, TimeUnit.MILLISECONDS);
    }

    @OnSuccess
    public synchronized void onSuccess(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Long payment, @Optional String sameNameParameter, @ParameterGroup(name="Dangerous-Ricin") @DisplayName(value="Dangerous Ricin") RicinGroup ricin, @ParameterGroup(name="Success Info", showInDsl=true) PersonalInfo successInfo, @org.mule.runtime.extension.api.annotation.param.Optional boolean fail, NotificationEmitter notificationEmitter) {
        gatheredMoney += payment.longValue();
        receivedGroupOnSource = ricin != null && ricin.getNextDoor().getAddress() != null;
        receivedInlineOnSuccess = successInfo != null && successInfo.getAge() != null && successInfo.getKnownAddresses() != null && successInfo.getDescription() != null;
        executedOnSuccess = true;
        notificationEmitter.fireLazy((NotificationActionDefinition)HeisenbergNotificationAction.BATCH_DELIVERED, () -> payment, DataType.fromType(Long.class));
        if (fail) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnError
    public synchronized void onError(Error error, @org.mule.runtime.extension.api.annotation.param.Optional String sameNameParameter, @org.mule.runtime.extension.api.annotation.param.Optional Methylamine methylamine, @ParameterGroup(name="Dangerous-Ricin") RicinGroup ricin, @org.mule.sdk.api.annotation.param.ParameterGroup(name="Error Info", showInDsl=true) PersonalInfo infoError, @Optional boolean propagateError, NotificationEmitter notificationEmitter) {
        gatheredMoney = -1L;
        receivedGroupOnSource = ricin != null && ricin.getNextDoor() != null && ricin.getNextDoor().getAddress() != null;
        receivedInlineOnError = infoError != null && infoError.getName() != null && !infoError.getName().equals("Heisenberg") && infoError.getDescription() != null;
        executedOnError = true;
        notificationEmitter.fireLazy((NotificationActionDefinition)HeisenbergNotificationAction.BATCH_DELIVERY_FAILED, () -> infoError, DataType.fromType(PersonalInfo.class));
        if (propagateError) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnTerminate
    public synchronized void onTerminate(SourceResult sourceResult, NotificationEmitter notificationEmitter) {
        if (sourceResult.isSuccess()) {
            terminateStatus = TerminateStatus.SUCCESS;
            error = java.util.Optional.empty();
        } else {
            sourceResult.getInvocationError().ifPresent(parameterError -> {
                terminateStatus = TerminateStatus.ERROR_INVOKE;
                error = java.util.Optional.of(parameterError);
            });
            sourceResult.getResponseError().ifPresent(bodyError -> {
                terminateStatus = TerminateStatus.ERROR_BODY;
                error = java.util.Optional.of(bodyError);
            });
        }
        executedOnTerminate = true;
        notificationEmitter.fireLazy((NotificationActionDefinition)HeisenbergNotificationAction.BATCH_TERMINATED, () -> sourceResult.getSourceCallbackContext().getVariable(BATCH_NUMBER).get(), DataType.fromType(Integer.class));
    }

    @OnBackPressure
    public void onBackPressure(BackPressureContext ctx, org.mule.sdk.api.notification.NotificationEmitter notificationEmitter) {
        notificationEmitter.fireLazy((org.mule.sdk.api.notification.NotificationActionDefinition)HeisenbergNotificationAction.BATCH_FAILED, () -> ctx.getSourceCallbackContext().getVariable(BATCH_NUMBER).get(), DataType.fromType(Integer.class));
        this.heisenberg.onBackPressure(ctx);
    }

    public synchronized void onStop() {
        if (this.executor != null && this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.executor.stop();
        }
        if (this.connection != null && this.connectionProvider != null) {
            this.connectionProvider.disconnect((Object)this.connection);
        }
        receivedGroupOnSource = false;
        gatheredMoney = 0L;
    }

    private Result<String, Object> makeResult(SourceCallback sourceCallback) {
        if (this.initialBatchNumber < 0) {
            sourceCallback.onConnectionException(new ConnectionException(INITIAL_BATCH_NUMBER_ERROR_MESSAGE));
            return null;
        }
        return Result.builder().output((Object)String.format("Meth Batch %d. If found by DEA contact %s", ++this.initialBatchNumber, this.connection.getSaulPhoneNumber())).build();
    }

    public static synchronized void resetHeisenbergSource() {
        receivedGroupOnSource = false;
        receivedInlineOnSuccess = false;
        receivedInlineOnError = false;
        receivedDebtProperties = null;
        receivedUsableWeapons = null;
        terminateStatus = TerminateStatus.NONE;
        error = null;
        executedOnSuccess = false;
        executedOnError = false;
        executedOnTerminate = false;
        gatheredMoney = 0L;
        location = null;
        configName = null;
    }

    public static enum TerminateStatus {
        SUCCESS,
        ERROR_INVOKE,
        ERROR_BODY,
        NONE;

    }
}

