/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.model.BarberPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExternalLib(name="Heisenberg.so", description="Native Heisenberg support", nameRegexpMatcher="heisenberg.so", requiredClassName="org.heisenberg.HeisenbergJNI", type=ExternalLibraryType.NATIVE)
public class HeisenbergConnectionProvider
implements ConnectionProvider<HeisenbergConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeisenbergConnectionProvider.class);
    public static final String SAUL_OFFICE_NUMBER = "505-503-4455";
    private static Set<HeisenbergConnection> activeConnections = new HashSet<HeisenbergConnection>();
    private static final AtomicInteger connects = new AtomicInteger();
    private static final AtomicInteger disconnects = new AtomicInteger();
    @Parameter
    @Optional(defaultValue="505-503-4455")
    private String saulPhoneNumber;
    @ParameterGroup(name="look", showInDsl=true)
    private BarberPreferences look;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeisenbergConnection connect() throws ConnectionException {
        LOGGER.info("'{}' connect()", (Object)this.toString());
        HeisenbergConnection connection = new HeisenbergConnection(this.saulPhoneNumber);
        Set<HeisenbergConnection> set = activeConnections;
        synchronized (set) {
            connects.incrementAndGet();
            activeConnections.add(connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HeisenbergConnection heisenbergConnection) {
        LOGGER.info("'{}' disconnect()", (Object)this.toString());
        Set<HeisenbergConnection> set = activeConnections;
        synchronized (set) {
            if (!activeConnections.remove(heisenbergConnection)) {
                throw new IllegalStateException(String.format("Connection '%s' was already disconnected", heisenbergConnection.toString()));
            }
            disconnects.incrementAndGet();
        }
    }

    public ConnectionValidationResult validate(HeisenbergConnection heisenbergConnection) {
        return ConnectionValidationResult.success();
    }

    public static int getConnects() {
        return connects.get();
    }

    public static int getDisconnects() {
        return disconnects.get();
    }

    public static Set<HeisenbergConnection> getActiveConnections() {
        return activeConnections;
    }
}

