/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.test.heisenberg.extension.model.Attribute;
import org.mule.test.heisenberg.extension.route.AfterCall;
import org.mule.test.heisenberg.extension.route.BeforeCall;
import org.mule.test.heisenberg.extension.route.OtherwiseRoute;
import org.mule.test.heisenberg.extension.route.WhenRoute;

public class HeisenbergRouters {
    public void simpleRouter(WhenRoute when, RouterCompletionCallback callback) {
        when.getChain().process(arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
    }

    public void twoRoutesRouter(String processorName, WhenRoute when, @Optional OtherwiseRoute other, RouterCompletionCallback callback) {
        if (when.shouldExecute()) {
            when.getChain().process(Result.builder().output((Object)processorName).attributes((Object)when.getMessage()).build(), arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
        } else if (other != null && other.shouldExecute()) {
            other.getChain().process((Object)processorName, null, arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
        } else {
            callback.error((Throwable)new IllegalArgumentException("No route executed"));
        }
    }

    public void stereotypedRoutes(WhenRoute first, @Optional OtherwiseRoute then, RouterCompletionCallback callback) {
        first.getChain().process(result -> {
            if (then != null) {
                then.getChain().process(result, arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
            } else {
                callback.success(result);
            }
        }, (e, r) -> callback.error(e));
    }

    @Summary(value="Allows to take actions over the event before and after the execution of a processor")
    public void spy(String processor, @Optional @NullSafe @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @Optional BeforeCall beforeCallAssertions, @Optional AfterCall afterCallAssertions, RouterCompletionCallback callback) {
        Map<String, Object> attr = withAttributes.stream().collect(Collectors.toMap(Attribute::getName, r -> r));
        if (beforeCallAssertions == null && afterCallAssertions == null) {
            callback.success(Result.builder().build());
        }
        if (beforeCallAssertions != null) {
            beforeCallAssertions.getChain().process(attr, null, success -> {
                System.out.println(processor);
                if (afterCallAssertions != null) {
                    afterCallAssertions.getChain().process(success, arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (t, e) -> callback.error(t));
                } else {
                    callback.success(success);
                }
            }, (error, lastResult) -> callback.error(error));
        } else if (afterCallAssertions != null) {
            afterCallAssertions.getChain().process(attr, null, arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (t, e) -> callback.error(t));
        } else {
            callback.success(Result.builder().build());
        }
    }
}

