/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.oauth;

import static org.mule.test.oauth.TestOAuthConnectionProvider.ACCESS_TOKEN_URL;
import static org.mule.test.oauth.TestOAuthConnectionProvider.AUTH_URL;

import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;

@AuthorizationCode(accessTokenUrl = ACCESS_TOKEN_URL, authorizationUrl = AUTH_URL,
    includeRedirectUriInRefreshTokenRequest = false)
@Alias("do-not-include-redirect-uri-in-refresh-token")
public class TestAuthorizationCodeDoNotIncludeRedirectUriParamConnectionProvider extends TestOAuthConnectionProvider {

}
