/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.maven.context.it;

import static java.lang.String.format;

import org.mule.maven.pom.parser.api.model.BundleDependency;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name = "resolve-artifact")
public class ResolveArtifactMojo extends AbstractMojo {

  @Parameter(required = true)
  String artifact;

  @Parameter(required = true)
  String localRepository;

  @Override
  public void execute() {
    try (DependencyResolver dependencyResolver = new DependencyResolver(localRepository)) {
      BundleDependency bundleDependency = dependencyResolver.resolveFor(artifact);

      getLog().info(format("Location of artifact '%s' is '%s'", artifact, bundleDependency.getBundleUri()));
    } catch (Exception e) {
      throw new RuntimeException("Error while resolving artifact", e);
    }
  }

}
