/*
 * Decompiled with CFR 0.152.
 */
package org.mule.templates.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String MYSQL_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm'Z'";

    private static String reformatZuluTimeZoneToOffsetIfNecesary(String date) {
        String reformatedDate = "";
        if (date.charAt(date.length() - 1) == 'Z') {
            reformatedDate = date.substring(0, date.length() - 1);
            reformatedDate = reformatedDate + "+00:00";
        } else {
            reformatedDate = date;
        }
        return reformatedDate;
    }

    public static boolean isAfter(String dateA, String dateB) {
        Validate.notEmpty((String)dateA, (String)"The date A should not be null or empty");
        Validate.notEmpty((String)dateB, (String)"The date A should not be null or empty");
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ'");
        DateTime lastModifiedDateOfA = formatter.withOffsetParsed().parseDateTime(DateUtils.reformatZuluTimeZoneToOffsetIfNecesary(dateA));
        DateTime lastModifiedDateOfB = formatter.parseDateTime(DateUtils.reformatZuluTimeZoneToOffsetIfNecesary(dateB));
        return lastModifiedDateOfA.isAfter((ReadableInstant)lastModifiedDateOfB);
    }

    public static String dateStringToISODateString(String date, String format, String timeZoneOffset) {
        DateTime dateTime = DateUtils.stringToDateTimeWithProvidedOffset(date, format, timeZoneOffset);
        return dateTime.toString();
    }

    public static DateTime stringToDateTimeWithProvidedOffset(String date, String format, String timeZoneOffset) {
        Validate.notEmpty((String)date, (String)"The date should not be null or empty");
        if (StringUtils.isEmpty((String)format)) {
            format = MYSQL_DATE_FORMAT;
        }
        if (StringUtils.isEmpty((String)timeZoneOffset)) {
            timeZoneOffset = "+00:00";
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        DateTime dateTime = formatter.withZone(DateTimeZone.forID((String)timeZoneOffset)).parseDateTime(date);
        return dateTime;
    }

    public static String dateToISODateString(Date date, String format, String timeZoneOffset) {
        String intermediateFormat = "MM/dd/yyyy HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(intermediateFormat);
        String dateWithNoTimeZone = df.format(date);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)intermediateFormat);
        DateTime dateTime = formatter.withZone(DateTimeZone.forID((String)timeZoneOffset)).parseDateTime(dateWithNoTimeZone);
        return dateTime.toString();
    }

    public static DateTime stringToDateTime(String date, String format) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        DateTime dateTime = formatter.withOffsetParsed().parseDateTime(DateUtils.reformatZuluTimeZoneToOffsetIfNecesary(date));
        return dateTime;
    }

    public static DateTime dateToDateTimeUsingProvidedOffset(Date date, String timeZoneOffset) {
        String intermediateFormat = "MM/dd/yyyy HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(intermediateFormat);
        String dateWithNoTimeZone = df.format(date);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)intermediateFormat);
        DateTime dateTime = formatter.withZone(DateTimeZone.forID((String)timeZoneOffset)).parseDateTime(dateWithNoTimeZone);
        return dateTime;
    }

    public static DateTime dateToDateTime(Date date) {
        return new DateTime((Object)date);
    }

    public static DateTime ISOStringDateToDateTime(String date) {
        return new DateTime((Object)date);
    }
}

