/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.annotations.Configuration;
import org.mule.extension.annotations.Configurations;
import org.mule.extension.annotations.Extension;
import org.mule.extension.annotations.ExtensionOf;
import org.mule.extension.annotations.Operations;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.introspection.ConfigurationInstantiator;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.declaration.Describer;
import org.mule.extension.introspection.declaration.fluent.ConfigurationDescriptor;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.extension.introspection.declaration.fluent.OperationDescriptor;
import org.mule.extension.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.extension.introspection.declaration.fluent.WithParameters;
import org.mule.module.extension.internal.capability.metadata.ExtendingOperationCapability;
import org.mule.module.extension.internal.capability.metadata.HiddenCapability;
import org.mule.module.extension.internal.capability.metadata.MemberNameCapability;
import org.mule.module.extension.internal.capability.metadata.ParameterGroupCapability;
import org.mule.module.extension.internal.capability.metadata.TypeRestrictionCapability;
import org.mule.module.extension.internal.introspection.CapabilitiesResolver;
import org.mule.module.extension.internal.introspection.DefaultCapabilitiesResolver;
import org.mule.module.extension.internal.introspection.MuleExtensionAnnotationParser;
import org.mule.module.extension.internal.introspection.ParameterDescriptor;
import org.mule.module.extension.internal.introspection.ParameterGroup;
import org.mule.module.extension.internal.introspection.TypeAwareConfigurationInstantiator;
import org.mule.module.extension.internal.runtime.ReflectiveOperationExecutorFactory;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.registry.SpiServiceRegistry;
import org.mule.util.CollectionUtils;
import org.mule.util.Preconditions;

public final class AnnotationsBasedDescriber
implements Describer {
    private CapabilitiesResolver capabilitiesResolver = new DefaultCapabilitiesResolver((ServiceRegistry)new SpiServiceRegistry());
    private final Class<?> extensionType;

    public AnnotationsBasedDescriber(Class<?> extensionType) {
        Preconditions.checkArgument((extensionType != null ? 1 : 0) != 0, (String)String.format("describer %s does not specify an extension type", this.getClass().getName()));
        this.extensionType = extensionType;
    }

    public final Descriptor describe() {
        Preconditions.checkArgument((this.extensionType != null ? 1 : 0) != 0, (String)String.format("describer %s does not specify an extension type", this.getClass().getName()));
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        DeclarationDescriptor declaration = this.newDeclarationDescriptor(extension);
        this.declareConfigurations(declaration, this.extensionType);
        this.declareOperations(declaration, this.extensionType);
        this.describeCapabilities(declaration, this.extensionType);
        return declaration;
    }

    private DeclarationDescriptor newDeclarationDescriptor(Extension extension) {
        return new DeclarationDescriptor(extension.name(), extension.version()).describedAs(extension.description());
    }

    private void declareConfigurations(DeclarationDescriptor declaration, Class<?> extensionType) {
        Configurations configurations = extensionType.getAnnotation(Configurations.class);
        if (configurations != null) {
            for (Class declaringClass : configurations.value()) {
                this.declareConfiguration(declaration, declaringClass);
            }
        } else {
            this.declareConfiguration(declaration, extensionType);
        }
    }

    private void declareConfiguration(DeclarationDescriptor declaration, Class<?> extensionType) {
        Preconditions.checkArgument((boolean)CollectionUtils.isEmpty(IntrospectionUtils.getOperationMethods(extensionType)), (String)String.format("Class %s can't declare a configuration and operations at the same time", extensionType.getName()));
        Configuration configurationAnnotation = extensionType.getAnnotation(Configuration.class);
        ConfigurationDescriptor configuration = configurationAnnotation != null ? declaration.withConfig(configurationAnnotation.name()).describedAs(configurationAnnotation.description()) : declaration.withConfig("config").describedAs("Default configuration");
        configuration.instantiatedWith((ConfigurationInstantiator)new TypeAwareConfigurationInstantiator(extensionType));
        this.declareConfigurationParameters(extensionType, configuration);
    }

    private void declareConfigurationParameters(Class<?> extensionType, ConfigurationDescriptor configuration) {
        this.declareSingleParameters(extensionType, configuration.with());
        List<ParameterGroup> groups = this.declareConfigurationParametersGroups(extensionType, configuration);
        if (!CollectionUtils.isEmpty(groups)) {
            configuration.withCapability((Object)new ParameterGroupCapability(groups));
        }
    }

    private List<ParameterGroup> declareConfigurationParametersGroups(Class<?> extensionType, ConfigurationDescriptor configuration) {
        LinkedList<ParameterGroup> groups = new LinkedList<ParameterGroup>();
        for (Field field : IntrospectionUtils.getParameterGroupFields(extensionType)) {
            Set<org.mule.extension.introspection.declaration.fluent.ParameterDescriptor> parameters = this.declareSingleParameters(field.getType(), configuration.with());
            if (parameters.isEmpty()) continue;
            ParameterGroup group = new ParameterGroup(field.getType(), field);
            groups.add(group);
            for (org.mule.extension.introspection.declaration.fluent.ParameterDescriptor descriptor : parameters) {
                ParameterDeclaration parameter = descriptor.getDeclaration();
                group.addParameter(parameter.getName(), IntrospectionUtils.getField(field.getType(), MuleExtensionAnnotationParser.getMemberName(parameter, parameter.getName()), parameter.getType().getRawType()));
            }
            List<ParameterGroup> childGroups = this.declareConfigurationParametersGroups(field.getType(), configuration);
            if (CollectionUtils.isEmpty(childGroups)) continue;
            group.addCapability(new ParameterGroupCapability(childGroups));
        }
        return groups;
    }

    private Set<org.mule.extension.introspection.declaration.fluent.ParameterDescriptor> declareSingleParameters(Class<?> extensionType, WithParameters with) {
        ImmutableSet.Builder parameters = ImmutableSet.builder();
        for (Field field : IntrospectionUtils.getParameterFields(extensionType)) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            Optional optional = field.getAnnotation(Optional.class);
            String parameterName = MuleExtensionAnnotationParser.getParameterName(field, parameter);
            DataType dataType = IntrospectionUtils.getFieldDataType(field);
            Object parameterDescriptor = optional == null ? with.requiredParameter(parameterName) : with.optionalParameter(parameterName).defaultingTo((Object)MuleExtensionUtils.getDefaultValue(optional));
            parameterDescriptor.ofType(dataType);
            if (!parameter.isDynamic()) {
                parameterDescriptor.whichIsStatic();
            }
            parameterDescriptor.withCapability((Object)new MemberNameCapability(field.getName()));
            parameters.add(parameterDescriptor);
        }
        return parameters.build();
    }

    private void declareOperations(DeclarationDescriptor declaration, Class<?> extensionType) {
        Operations operations = extensionType.getAnnotation(Operations.class);
        if (operations != null) {
            for (Class actingClass : operations.value()) {
                this.declareOperation(declaration, actingClass);
            }
        } else {
            this.declareOperation(declaration, extensionType);
        }
    }

    private <T> void declareOperation(DeclarationDescriptor declaration, Class<T> actingClass) {
        for (Method method : IntrospectionUtils.getOperationMethods(actingClass)) {
            OperationDescriptor operation = declaration.withOperation(method.getName()).executorsCreatedBy(new ReflectiveOperationExecutorFactory<T>(actingClass, method));
            this.declareOperationParameters(method, operation);
            this.calculateExtendedTypes(actingClass, method, operation);
        }
    }

    private void calculateExtendedTypes(Class<?> actingClass, Method method, OperationDescriptor operation) {
        ExtensionOf extensionOf = method.getAnnotation(ExtensionOf.class);
        if (extensionOf == null) {
            extensionOf = actingClass.getAnnotation(ExtensionOf.class);
        }
        if (extensionOf != null) {
            operation.withCapability(new ExtendingOperationCapability(extensionOf.value()));
        }
    }

    private void declareOperationParameters(Method method, OperationDescriptor operation) {
        List<ParameterDescriptor> descriptors = MuleExtensionAnnotationParser.parseParameters(method);
        for (ParameterDescriptor parameterDescriptor : descriptors) {
            org.mule.extension.introspection.declaration.fluent.ParameterDescriptor parameter = parameterDescriptor.isRequired() ? operation.with().requiredParameter(parameterDescriptor.getName()) : operation.with().optionalParameter(parameterDescriptor.getName()).defaultingTo(parameterDescriptor.getDefaultValue());
            parameter.describedAs("").ofType(parameterDescriptor.getType());
            this.hideIfNecessary(parameterDescriptor, parameter);
            this.addTypeRestrictions(parameter, parameterDescriptor);
        }
    }

    private void hideIfNecessary(ParameterDescriptor parameterDescriptor, org.mule.extension.introspection.declaration.fluent.ParameterDescriptor parameter) {
        if (parameterDescriptor.isHidden()) {
            parameter.withCapability((Object)new HiddenCapability());
        }
    }

    private void addTypeRestrictions(org.mule.extension.introspection.declaration.fluent.ParameterDescriptor parameter, ParameterDescriptor descriptor) {
        Class<?> restriction = descriptor.getTypeRestriction();
        if (restriction != null) {
            parameter.withCapability(new TypeRestrictionCapability(restriction));
        }
    }

    private void describeCapabilities(DeclarationDescriptor declaration, Class<?> extensionType) {
        this.capabilitiesResolver.resolveCapabilities(declaration, extensionType);
    }
}

