/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.reflect.Method;
import org.apache.commons.lang.ArrayUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.runtime.ArgumentResolverDelegate;
import org.mule.module.extension.internal.runtime.MethodArgumentResolverDelegate;
import org.mule.module.extension.internal.runtime.ReturnDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class ReflectiveMethodOperationExecutor
implements OperationExecutor,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveMethodOperationExecutor.class);
    private static final ArgumentResolverDelegate NO_ARGS_DELEGATE = new NoArgumentsResolverDelegate();
    private final Method operationMethod;
    private final Object executorDelegate;
    private final ReturnDelegate returnDelegate;
    private final ArgumentResolverDelegate argumentResolverDelegate;
    private MuleContext muleContext;

    ReflectiveMethodOperationExecutor(Method operationMethod, Object executorDelegate, ReturnDelegate returnDelegate) {
        this.operationMethod = operationMethod;
        this.executorDelegate = executorDelegate;
        this.returnDelegate = returnDelegate;
        this.argumentResolverDelegate = ArrayUtils.isEmpty((Object[])operationMethod.getParameterTypes()) ? NO_ARGS_DELEGATE : new MethodArgumentResolverDelegate(operationMethod);
    }

    public Object execute(OperationContext operationContext) throws Exception {
        Object result = ReflectionUtils.invokeMethod((Method)this.operationMethod, (Object)this.executorDelegate, (Object[])this.getParameterValues(operationContext));
        return this.returnDelegate.asReturnValue(result, operationContext);
    }

    private Object[] getParameterValues(OperationContext operationContext) {
        return this.argumentResolverDelegate.resolve(operationContext);
    }

    public void initialise() throws InitialisationException {
        try {
            this.muleContext.getInjector().inject(this.executorDelegate);
        }
        catch (MuleException e) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)("Could not perform dependency injection on operation class " + this.executorDelegate.getClass().getName())), (Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.executorDelegate);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.executorDelegate);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.executorDelegate);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.executorDelegate, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.executorDelegate instanceof MuleContextAware) {
            ((MuleContextAware)this.executorDelegate).setMuleContext(context);
        }
    }

    private static class NoArgumentsResolverDelegate
    implements ArgumentResolverDelegate {
        private static final Object[] EMPTY = new Object[0];

        private NoArgumentsResolverDelegate() {
        }

        @Override
        public Object[] resolve(OperationContext operationContext) {
            return EMPTY;
        }
    }
}

