/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.introspection.ConfigurationInstantiator;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.util.Preconditions;

final class TypeAwareConfigurationInstantiator
implements ConfigurationInstantiator {
    private final Class<?> configurationType;

    TypeAwareConfigurationInstantiator(Class<?> configurationType) {
        Preconditions.checkArgument((configurationType != null ? 1 : 0) != 0, (String)"configuration type cannot be null");
        IntrospectionUtils.checkInstantiable(configurationType);
        this.configurationType = configurationType;
    }

    public Object newInstance() {
        try {
            return this.configurationType.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not instantiate configuration of type " + this.configurationType.getName())), (Throwable)e);
        }
    }

    public Class<?> getObjectType() {
        return this.configurationType;
    }
}

